/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.LearningLibraryGroup;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.springframework.stereotype.Repository;

@Repository
public class LearningLibraryDAO
extends LAMSBaseDAO
implements ILearningLibraryDAO {
    private static final String FIND_VALID_LIB = "from " + LearningLibrary.class.getName() + " l where l.validLibrary=true";
    private static final String FIND_ALL_LIB = "from " + LearningLibrary.class.getName();

    @Override
    public LearningLibrary getLearningLibraryById(Long learningLibraryId) {
        return (LearningLibrary)super.find(LearningLibrary.class, learningLibraryId);
    }

    @Override
    public List<LearningLibrary> getAllLearningLibraries() {
        return this.getSession().createQuery(FIND_VALID_LIB).list();
    }

    @Override
    public List<LearningLibrary> getAllLearningLibraries(boolean valid) {
        if (valid) {
            return this.getAllLearningLibraries();
        }
        return this.doFind(FIND_ALL_LIB, new Object[0]);
    }

    @Override
    public List<LearningLibraryGroup> getLearningLibraryGroups() {
        return this.loadAll(LearningLibraryGroup.class);
    }
}

