/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.LearningLibraryGroup;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignValidator;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dto.ToolDTO;
import org.lamsfoundation.lams.tool.dto.ToolDTONameComparator;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class LearningDesignService
implements ILearningDesignService {
    protected Logger log = Logger.getLogger(LearningDesignService.class);
    protected MessageService messageService;
    protected ILearningDesignDAO learningDesignDAO;
    protected IActivityDAO activityDAO;
    protected IGroupingDAO groupingDAO;
    protected ILearningLibraryDAO learningLibraryDAO;
    protected ILoadedMessageSourceService toolActMessageService;
    private static final String LD_SVG_DIR = "lams-www.war\\secure\\learning-design-images";

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public ILoadedMessageSourceService getToolActMessageService() {
        return this.toolActMessageService;
    }

    public void setToolActMessageService(ILoadedMessageSourceService toolActMessageService) {
        this.toolActMessageService = toolActMessageService;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    @Override
    public LearningDesignDTO getLearningDesignDTO(Long learningDesignID, String languageCode) {
        LearningDesign design = learningDesignID != null ? this.learningDesignDAO.getLearningDesignById(learningDesignID) : null;
        return design != null ? new LearningDesignDTO(design, this.activityDAO, this.groupingDAO, languageCode) : null;
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(LearningDesign learningDesign) {
        LearningDesignValidator validator = new LearningDesignValidator(learningDesign, this.messageService);
        return validator.validate();
    }

    @Override
    public void setValid(Long learningLibraryId, boolean valid) {
        LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryId);
        library.setValidLibrary(valid);
        this.learningLibraryDAO.update(library);
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails(String languageCode) throws IOException {
        return this.getAllLearningLibraryDetails(true, languageCode);
    }

    @Override
    public LearningLibrary getLearningLibrary(Long learningLibraryId) {
        return (LearningLibrary)this.learningDesignDAO.find(LearningLibrary.class, learningLibraryId);
    }

    @Override
    public List<LearningLibraryGroup> getLearningLibraryGroups() {
        return this.learningLibraryDAO.getLearningLibraryGroups();
    }

    @Override
    public void saveLearningLibraryGroups(Collection<LearningLibraryGroup> groups) {
        List<LearningLibraryGroup> existingGroups = this.learningLibraryDAO.getLearningLibraryGroups();
        HashSet<LearningLibraryGroup> removeGroups = new HashSet<LearningLibraryGroup>(existingGroups);
        removeGroups.removeAll(groups);
        existingGroups.removeAll(removeGroups);
        this.learningLibraryDAO.deleteAll(removeGroups);
        for (LearningLibraryGroup group : groups) {
            boolean found = false;
            for (LearningLibraryGroup existingGroup : existingGroups) {
                if (!existingGroup.equals(group)) continue;
                existingGroup.setName(group.getName());
                existingGroup.setLearningLibraries(group.getLearningLibraries());
                this.learningLibraryDAO.update(existingGroup);
                found = true;
                break;
            }
            if (found) continue;
            this.learningDesignDAO.insert(group);
        }
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails(boolean valid, String languageCode) throws IOException {
        Iterator<LearningLibrary> iterator = this.learningLibraryDAO.getAllLearningLibraries(valid).iterator();
        ArrayList<LearningLibraryDTO> libraries = new ArrayList<LearningLibraryDTO>();
        while (iterator.hasNext()) {
            LearningLibrary learningLibrary = iterator.next();
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            if (templateActivities != null & templateActivities.size() == 0) {
                this.log.error((Object)("Learning Library with ID " + learningLibrary.getLearningLibraryId() + " \"" + learningLibrary.getTitle() + "\" does not have a template activity"));
            }
            LearningLibraryDTO libraryDTO = new LearningLibraryDTO(learningLibrary);
            libraryDTO.setTemplateActivities(this.populateActivities(templateActivities.iterator(), languageCode));
            this.internationaliseActivities(libraryDTO.getTemplateActivities());
            libraries.add(libraryDTO);
        }
        return libraries;
    }

    private Vector populateActivities(Iterator iterator, String languageCode) {
        Vector<LibraryActivityDTO> activities = new Vector<LibraryActivityDTO>();
        Vector<LibraryActivityDTO> childActivities = null;
        while (iterator.hasNext()) {
            Activity object = (Activity)iterator.next();
            if (object.isComplexActivity()) {
                object = this.activityDAO.getActivityByActivityId(object.getActivityId());
                ComplexActivity complexActivity = (ComplexActivity)object;
                Iterator childIterator = complexActivity.getActivities().iterator();
                childActivities = new Vector<LibraryActivityDTO>();
                while (childIterator.hasNext()) {
                    Activity activity = (Activity)childIterator.next();
                    childActivities.add(activity.getLibraryActivityDTO(languageCode));
                }
                activities.add(complexActivity.getLibraryActivityDTO(languageCode));
                activities.addAll(childActivities);
                continue;
            }
            activities.add(object.getLibraryActivityDTO(languageCode));
        }
        return activities;
    }

    @Override
    public List<ToolDTO> getToolDTOs(boolean includeParallel, boolean includeInvalid, String userName) throws IOException {
        User user = (User)this.learningLibraryDAO.findByProperty(User.class, "login", userName).get(0);
        String languageCode = user.getLocale().getLanguageIsoCode();
        ArrayList<LearningLibraryDTO> learningLibraries = this.getAllLearningLibraryDetails(false, languageCode);
        ArrayList<ToolDTO> tools = new ArrayList<ToolDTO>();
        for (LearningLibraryDTO learningLibrary : learningLibraries) {
            boolean isParallel;
            Vector libraryActivityDTOs = learningLibrary.getTemplateActivities();
            if (libraryActivityDTOs.isEmpty()) {
                this.log.error((Object)("Learning Library with ID " + learningLibrary.getLearningLibraryID() + " \"" + learningLibrary.getTitle() + "\" does not have a template activity"));
                continue;
            }
            boolean bl = isParallel = libraryActivityDTOs.size() > 1;
            if (!includeInvalid && !learningLibrary.getValidFlag().booleanValue() || !includeParallel && isParallel) continue;
            LibraryActivityDTO libraryActivityDTO = (LibraryActivityDTO)libraryActivityDTOs.get(0);
            ToolDTO toolDTO = new ToolDTO();
            if (isParallel) {
                ArrayList<Long> childLibraryIDs = new ArrayList<Long>();
                for (LibraryActivityDTO childActivityDTO : libraryActivityDTOs) {
                    Long childToolID = childActivityDTO.getToolID();
                    if (childToolID == null) continue;
                    childLibraryIDs.add(childToolID);
                }
                toolDTO.setChildToolIds(childLibraryIDs.toArray(new Long[0]));
            } else {
                toolDTO.setToolId(libraryActivityDTO.getToolID());
            }
            toolDTO.setLearningLibraryId(learningLibrary.getLearningLibraryID());
            toolDTO.setLearningLibraryTitle(learningLibrary.getTitle());
            toolDTO.setToolDisplayName(isParallel ? learningLibrary.getTitle() : libraryActivityDTO.getActivityTitle());
            toolDTO.setActivityCategoryID(isParallel ? 5 : libraryActivityDTO.getActivityCategoryID());
            toolDTO.setValid(learningLibrary.getValidFlag());
            if (libraryActivityDTO.getToolID() == null) {
                toolDTO.setIconPath(libraryActivityDTO.getLibraryActivityUIImage());
            } else {
                Tool tool = (Tool)this.learningLibraryDAO.find(Tool.class, libraryActivityDTO.getToolID());
                String iconPath = "tool/" + tool.getToolSignature() + "/images/icon_" + tool.getToolIdentifier() + ".svg";
                toolDTO.setIconPath(iconPath);
                toolDTO.setSupportsOutputs(tool.getSupportsOutputs());
                toolDTO.setDefaultToolContentId(tool.getDefaultToolContentId());
            }
            tools.add(toolDTO);
        }
        Collections.sort(tools, new ToolDTONameComparator());
        return tools;
    }

    private void internationaliseActivities(Collection<LibraryActivityDTO> activities) {
        Iterator<LibraryActivityDTO> iter = activities.iterator();
        Locale locale = LocaleContextHolder.getLocale();
        if (this.log.isDebugEnabled() && locale == null) {
            this.log.debug((Object)"internationaliseActivities: Locale missing.");
        }
        while (iter.hasNext()) {
            LibraryActivityDTO activity = iter.next();
            String languageFilename = activity.getLanguageFile();
            if (languageFilename != null) {
                MessageSource toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setActivityTitle(toolMessageSource.getMessage("activity.title", null, activity.getActivityTitle(), locale));
                    activity.setDescription(toolMessageSource.getMessage("activity.description", null, activity.getDescription(), locale));
                    activity.setHelpText(toolMessageSource.getMessage("activity.helptext", null, activity.getHelpText(), locale));
                } else {
                    this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Activity Message source not available"));
                }
                if (activity.getActivityTypeID() == null || 1 != activity.getActivityTypeID()) continue;
                languageFilename = activity.getToolLanguageFile();
                toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setToolDisplayName(toolMessageSource.getMessage("tool.display.name", null, activity.getToolDisplayName(), locale));
                    continue;
                }
                this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Tool Message source not available"));
                continue;
            }
            this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + ". No message file supplied."));
        }
    }

    public static String getLearningDesignSVGPath(long learningDesignId) {
        String earDirPath = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR);
        String svgDirPath = FileUtil.getFullPath(earDirPath, LD_SVG_DIR);
        return FileUtil.getFullPath(svgDirPath, learningDesignId + ".svg");
    }
}

