/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCommentDAO;
import org.lamsfoundation.lams.rating.dto.RatingCommentDTO;
import org.lamsfoundation.lams.rating.model.RatingComment;

public class RatingCommentDAO
extends LAMSBaseDAO
implements IRatingCommentDAO {
    private static final String FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM = "FROM " + RatingComment.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_COMMENTS_BY_CRITERIA_AND_ITEM = "SELECT r.itemId, r.learner.userId, r.comment, CONCAT(r.learner.firstName, ' ', r.learner.lastName), r.postedDate FROM " + RatingComment.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.itemId=?";
    private static final String FIND_COMMENTS_BY_CRITERIA_AND_ITEMS = "SELECT r.itemId, r.learner.userId, r.comment, CONCAT(r.learner.firstName, ' ', r.learner.lastName), r.postedDate FROM " + RatingComment.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=:ratingCriteriaId AND r.itemId IN (:itemIds)";
    private static final String FIND_COMMENTS_BY_CRITERIA_AND_ITEMS_AND_USER = "SELECT r.itemId, r.learner.userId, r.comment FROM " + RatingComment.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=:ratingCriteriaId AND r.itemId IN (:itemIds) AND r.learner.userId=:userId";
    private static final String FIND_COMMENTS_BY_CRITERIA = "SELECT r.itemId, r.learner.userId, r.comment FROM " + RatingComment.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=?";

    @Override
    public List<RatingCommentDTO> getCommentsByCriteriaAndItem(Long ratingCriteriaId, Long itemId) {
        List<Object[]> results = this.doFind(FIND_COMMENTS_BY_CRITERIA_AND_ITEM, ratingCriteriaId, itemId);
        return this.convertIntoCommentDtos(results);
    }

    @Override
    public List<RatingCommentDTO> getCommentsByCriteriaAndItems(Long ratingCriteriaId, Collection<Long> itemIds) {
        List results = this.getSession().createQuery(FIND_COMMENTS_BY_CRITERIA_AND_ITEMS).setLong("ratingCriteriaId", ratingCriteriaId.longValue()).setParameterList("itemIds", itemIds).list();
        return this.convertIntoCommentDtos(results);
    }

    @Override
    public List<RatingCommentDTO> getCommentsByCriteriaAndItemsAndUser(Long ratingCriteriaId, Collection<Long> itemIds, Integer userId) {
        List results = this.getSession().createQuery(FIND_COMMENTS_BY_CRITERIA_AND_ITEMS_AND_USER).setLong("ratingCriteriaId", ratingCriteriaId.longValue()).setParameterList("itemIds", itemIds).setInteger("userId", userId.intValue()).list();
        return this.convertIntoCommentDtos(results);
    }

    @Override
    public List<RatingCommentDTO> getCommentsByCriteria(Long ratingCriteriaId) {
        List<Object[]> results = this.doFind(FIND_COMMENTS_BY_CRITERIA, ratingCriteriaId);
        return this.convertIntoCommentDtos(results);
    }

    private List<RatingCommentDTO> convertIntoCommentDtos(List<Object[]> results) {
        LinkedList<RatingCommentDTO> commentDtos = new LinkedList<RatingCommentDTO>();
        for (Object[] result : results) {
            Long itemId = (Long)result[0];
            Long userId = ((Integer)result[1]).longValue();
            String comment = (String)result[2];
            String userName = "";
            Date postedDate = null;
            if (result.length > 3) {
                userName = (String)result[3];
                postedDate = (Date)result[4];
            }
            RatingCommentDTO commentDto = new RatingCommentDTO(itemId, userId, userName, comment, postedDate);
            commentDtos.add(commentDto);
        }
        return commentDtos;
    }

    @Override
    public RatingComment getComment(Long ratingCriteriaId, Integer userId, Long itemId) {
        List<?> list = this.doFind(FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM, ratingCriteriaId, userId, itemId);
        if (list.size() > 0) {
            return (RatingComment)list.get(0);
        }
        return null;
    }
}

