/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.ItemRatingCriteriaDTO;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingComment;

public class RatingDAO
extends LAMSBaseDAO
implements IRatingDAO {
    private static final String FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_USER_RATING_VALUE = "SELECT r.rating FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_RATING_BY_CRITERIA_AND_USER = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=?";
    private static final String FIND_RATINGS_BY_ITEM = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.itemId=?";
    private static final String FIND_RATINGS_BY_USER = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.learner.userId=?";
    private static final String FIND_RATING_AVERAGE_BY_ITEM = "SELECT AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.itemId=?";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEM = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.itemId=? GROUP BY r.ratingCriteria.ratingCriteriaId";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEMS = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=:contentId AND r.itemId IN (:itemIds) GROUP BY r.itemId, r.ratingCriteria.ratingCriteriaId";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_ID = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? GROUP BY r.itemId, r.ratingCriteria.ratingCriteriaId";

    @Override
    public void saveOrUpdate(Object object) {
        this.getSession().saveOrUpdate(object);
        this.getSession().flush();
    }

    @Override
    public Rating getRating(Long ratingCriteriaId, Integer userId, Long itemId) {
        List<?> list = this.doFind(FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM, ratingCriteriaId, userId, itemId);
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public List<Rating> getRatingsByItem(Long contentId, Long itemId) {
        return super.find(FIND_RATINGS_BY_ITEM, new Object[]{contentId, itemId});
    }

    private Rating getRating(Long ratingCriteriaId, Integer userId) {
        List<?> list = this.doFind(FIND_RATING_BY_CRITERIA_AND_USER, ratingCriteriaId, userId);
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public List<Rating> getRatingsByUser(Long contentId, Integer userId) {
        return this.doFind(FIND_RATINGS_BY_USER, contentId, userId);
    }

    @Override
    public ItemRatingCriteriaDTO getRatingAverageDTOByItem(Long ratingCriteriaId, Long itemId) {
        List<?> list = this.doFind(FIND_RATING_AVERAGE_BY_ITEM, ratingCriteriaId, itemId);
        Object[] results = (Object[])list.get(0);
        Object averageRatingObj = results[0] == null ? Integer.valueOf(0) : results[0];
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        String averageRating = numberFormat.format(averageRatingObj);
        String numberOfVotes = results[1] == null ? "0" : String.valueOf(results[1]);
        return new ItemRatingCriteriaDTO(averageRating, numberOfVotes);
    }

    @Override
    public List<Object[]> getRatingAverageByContentAndItem(Long contentId, Long itemId) {
        return this.doFind(FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEM, contentId, itemId);
    }

    @Override
    public List<Object[]> getRatingAverageByContentAndItems(Long contentId, Collection<Long> itemIds) {
        return this.getSession().createQuery(FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setParameterList("itemIds", itemIds).list();
    }

    @Override
    public List<Object[]> getRatingAverageByContent(Long contentId) {
        return this.doFind(FIND_RATING_AVERAGE_BY_CONTENT_ID, contentId);
    }

    @Override
    public Rating get(Long uid) {
        if (uid != null) {
            Object o = super.find(Rating.class, uid);
            return (Rating)o;
        }
        return null;
    }

    @Override
    public int getCountItemsRatedByUser(Long toolContentId, Integer userId) {
        String FIND_ITEM_IDS_RATED_BY_USER = "SELECT DISTINCT r.itemId FROM  " + Rating.class.getName() + " AS r " + " WHERE r.ratingCriteria.toolContentId = :toolContentId AND r.learner.userId =:userId";
        String FIND_ITEM_IDS_COMMENTED_BY_USER = "SELECT DISTINCT comment.itemId FROM " + RatingComment.class.getName() + " AS comment " + " WHERE comment.ratingCriteria.toolContentId = :toolContentId AND comment.learner.userId =:userId AND comment.ratingCriteria.commentsEnabled IS TRUE";
        List ratedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_RATED_BY_USER).setLong("toolContentId", toolContentId.longValue()).setInteger("userId", userId.intValue()).list();
        List commentedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_COMMENTED_BY_USER).setLong("toolContentId", toolContentId.longValue()).setInteger("userId", userId.intValue()).list();
        HashSet unionItemIds = new HashSet(ratedItemIds);
        unionItemIds.addAll(commentedItemIds);
        return unionItemIds.size();
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItem(Long contentId, Collection<Long> itemIds, Integer excludeUserId) {
        HashMap<Long, Long> itemIdToRatedUsersCountMap = new HashMap<Long, Long>();
        if (itemIds.isEmpty()) {
            return itemIdToRatedUsersCountMap;
        }
        String FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT r.itemId, r.learner.userId FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=:contentId AND r.itemId IN (:itemIds)";
        String FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT comment.itemId, comment.learner.userId FROM " + RatingComment.class.getName() + " AS r where comment.ratingCriteria.toolContentId=:contentId AND comment.itemId IN (:itemIds) AND comment.ratingCriteria.commentsEnabled IS TRUE";
        List ratedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setParameterList("itemIds", itemIds).list();
        List commentedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setParameterList("itemIds", itemIds).list();
        for (Long itemId : itemIds) {
            Integer userIdIter;
            Long itemIdIter;
            HashSet<Integer> userIds = new HashSet<Integer>();
            for (Object[] ratedItemObj : ratedItemObjs) {
                itemIdIter = (Long)ratedItemObj[0];
                userIdIter = (Integer)ratedItemObj[1];
                if (!itemIdIter.equals(itemId)) continue;
                userIds.add(userIdIter);
            }
            for (Object[] commentedItemObj : commentedItemObjs) {
                itemIdIter = (Long)commentedItemObj[0];
                userIdIter = (Integer)commentedItemObj[1];
                if (!itemIdIter.equals(itemId)) continue;
                userIds.add(userIdIter);
            }
            userIds.remove(excludeUserId);
            itemIdToRatedUsersCountMap.put(itemId, new Long(userIds.size()));
        }
        return itemIdToRatedUsersCountMap;
    }
}

