/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.springframework.stereotype.Repository;

@Repository
public class OrganisationDAO
extends LAMSBaseDAO
implements IOrganisationDAO {
    private static final String GET_ALL_ACTIVE_COURSE_IDS = "select o.organisationId from Organisation o where o.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " order by name";
    private static final String GET_ACTIVE_COURSE_IDS_BY_USER = "select uo.organisation.organisationId, uoc.collapsed from UserOrganisation uo left join uo.userOrganisationCollapsed uoc where uo.organisation.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and uo.organisation.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " and uo.user.userId = :userId order by name";
    private static final String GET_PAGED_COURSES = "SELECT o FROM Organisation o WHERE o.organisationType.organisationTypeId =:typeId AND o.organisationState.organisationStateId =:stateId AND o.parentOrganisation.organisationId =:parentOrgId AND (o.name LIKE CONCAT('%', :searchString, '%')) ORDER BY ";
    private static final String GET_COUNT_COURSES_BY_PARENT_TYPE_STATE = "SELECT count(*) FROM Organisation o  WHERE o.parentOrganisation.organisationId =:parentOrgId  AND o.organisationType.organisationTypeId =:typeId  AND o.organisationState.organisationStateId =:stateId  AND (o.name LIKE CONCAT('%', :searchString, '%')) ";

    @Override
    public List<Integer> getActiveCourseIdsByUser(Integer userId, boolean isSysadmin) {
        return isSysadmin ? this.getSession().createQuery(GET_ALL_ACTIVE_COURSE_IDS).list() : this.getSession().createQuery(GET_ACTIVE_COURSE_IDS_BY_USER).setInteger("userId", userId.intValue()).list();
    }

    @Override
    public List<Organisation> getPagedCourses(Integer parentOrgId, Integer typeId, Integer stateId, int page, int size, String sortBy, String sortOrder, String searchString) {
        String sortByParam = "o.name";
        switch (sortBy) {
            case "id": {
                sortByParam = "o.organisationId";
                break;
            }
            case "name": {
                sortByParam = "o.name";
                break;
            }
            case "code": {
                sortByParam = "o.code";
                break;
            }
            case "description": {
                sortByParam = "o.description";
            }
        }
        Query query = this.getSession().createQuery(GET_PAGED_COURSES + sortByParam + " " + sortOrder);
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        query.setInteger("parentOrgId", parentOrgId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        return query.list();
    }

    @Override
    public int getCountCoursesByParentCourseAndTypeAndState(Integer parentOrgId, Integer typeId, Integer stateId, String searchString) {
        Query query = this.getSession().createQuery(GET_COUNT_COURSES_BY_PARENT_TYPE_STATE);
        query.setInteger("parentOrgId", parentOrgId.intValue());
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        return ((Number)query.uniqueResult()).intValue();
    }
}

