/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class HelpUtil {
    private static final String LAMSFOUNDATION_TEXT = "lamsfoundation";
    private static final String LAMSDOCS = "lamsdocs";
    private static final String ENGLISH_LANGUAGE = "en";

    public static String constructToolURL(String baseToolURL, String toolSignature, String module, String languageCode) {
        if (baseToolURL == null) {
            return null;
        }
        String helpURL = HelpUtil.addLanguageToURL(baseToolURL, languageCode);
        if (module != null && module.length() > 0) {
            helpURL = helpURL + module + "#" + toolSignature + module;
        }
        return helpURL;
    }

    public static String constructPageURL(String page, String languageCode) {
        return HelpUtil.addLanguageToURL(Configuration.get(ConfigurationKeys.HELP_URL), languageCode) + page;
    }

    private static String addLanguageToURL(String helpURL, String languageCode) {
        if (languageCode != null && !languageCode.equals(ENGLISH_LANGUAGE) && helpURL != null && helpURL.indexOf(LAMSFOUNDATION_TEXT) != -1) {
            return helpURL.replace(LAMSDOCS, LAMSDOCS + languageCode);
        }
        return helpURL;
    }
}

