-- Turn off autocommit, so nothing is committed if there is an error

SET AUTOCOMMIT = 0;
SET FOREIGN_KEY_CHECKS=0;

-- LDEV-3629 Use 4 bytes Unicode characters in the whole DB

-- Alter character set and encoding of the each table.
-- The database char set needs to be altered manually as at this point we do not know its name.
-- Limit indexed text fields' length.

ALTER TABLE lams_activity_category CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_activity_evaluation CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_auth_method_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_authentication_method CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
									   MODIFY COLUMN authentication_method_name VARCHAR(191) NOT NULL;
ALTER TABLE lams_branch_activity_entry CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_branch_condition CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_competence CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
							MODIFY COLUMN title VARCHAR(191) NOT NULL;
ALTER TABLE lams_competence_mapping CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_copy_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_credential CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_node CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_node_version CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_node_version_property CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_workspace CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_cr_workspace_credential CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_data_flow CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_event_subscriptions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_events CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_ext_course_class_map CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_ext_server_lesson_map CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_ext_server_org_map CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
									MODIFY COLUMN serverid VARCHAR(191) NOT NULL;
ALTER TABLE lams_ext_server_tool_map CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_ext_user_userid_map CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_gate_activity_level CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_gate_allowed_learners CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_gradebook_user_activity CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_gradebook_user_lesson CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_grouping CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_grouping_support_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_grouping_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_input_activity CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learner_progress CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_activity CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_activity_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_design CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_design_access CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_design_annotation CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_library CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_library_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_library_to_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_learning_transition CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_lesson CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_lesson_dependency CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_lesson_state CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_license CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_log_event CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_log_event_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_notebook_entry CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_openid_config CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_organisation CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_organisation_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_organisation_grouping CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_organisation_state CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_organisation_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_password_request CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_planner_activity_metadata CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_planner_node_role CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_planner_nodes CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_planner_recent_learning_designs CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_presence_chat_msgs CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_presence_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
							   MODIFY COLUMN nickname VARCHAR(191) NOT NULL;
ALTER TABLE lams_privilege CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_progress_attempted CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_progress_completed CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_qtz_BLOB_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								   MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
								   MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_CALENDARS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
							   MODIFY COLUMN CALENDAR_NAME varchar(191) NOT NULL;
ALTER TABLE lams_qtz_CRON_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								   MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
								   MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_FIRED_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								    MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
								    MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL,
								    MODIFY COLUMN INSTANCE_NAME varchar(191) NOT NULL,
								    MODIFY COLUMN JOB_NAME varchar(191) DEFAULT NULL,
								    MODIFY COLUMN JOB_GROUP varchar(191) DEFAULT NULL;
ALTER TABLE lams_qtz_JOB_DETAILS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								 MODIFY COLUMN JOB_NAME varchar(191) NOT NULL,
								 MODIFY COLUMN JOB_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_LOCKS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_qtz_PAUSED_TRIGGER_GRPS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								   		 MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_SCHEDULER_STATE CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
		   						     MODIFY COLUMN INSTANCE_NAME varchar(191) NOT NULL;
ALTER TABLE lams_qtz_SIMPLE_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								     MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
								     MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_SIMPROP_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								      MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
								      MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL;
ALTER TABLE lams_qtz_TRIGGERS CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
							  MODIFY COLUMN TRIGGER_NAME varchar(191) NOT NULL,
							  MODIFY COLUMN TRIGGER_GROUP varchar(191) NOT NULL,
							  MODIFY COLUMN JOB_NAME varchar(191) NOT NULL,
							  MODIFY COLUMN JOB_GROUP varchar(191) NOT NULL,
							  MODIFY COLUMN CALENDAR_NAME varchar(191) DEFAULT NULL;
ALTER TABLE lams_rating CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_rating_comment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_rating_criteria CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_rating_criteria_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_registration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_role CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_role_privilege CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_signup_organisation CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
									 MODIFY COLUMN context VARCHAR(191) NOT NULL;
ALTER TABLE lams_supported_locale CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_system_tool CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_text_search_condition CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_theme CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_timezone CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_tool CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
					  MODIFY COLUMN service_name VARCHAR(191) NOT NULL;
ALTER TABLE lams_tool_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_tool_import_support CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_tool_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_tool_session_state CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_tool_session_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
					  MODIFY COLUMN login VARCHAR(191) NOT NULL;
ALTER TABLE lams_user_disabled_tutorials CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user_organisation CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user_organisation_collapsed CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user_organisation_group CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_user_organisation_role CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_wkspc_fld_content_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_wkspc_wkspc_folder CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_workspace CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_workspace_folder CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_workspace_folder_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE lams_workspace_folder_type CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE patches CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_condition CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_condition_expression CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_eadventure CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_param CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_eueadv10_var CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_assessment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_assessment_overall_feedback CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_assessment_question CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_assessment_result CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_assessment_unit CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_option_answer CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_question_option CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_question_reference CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_question_result CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laasse10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_labbb10_bbb CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_labbb10_config CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_labbb10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_labbb10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lachat11_chat CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lachat11_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lachat11_message CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lachat11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lachat11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_answer_options CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_answers CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_contents CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_questions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_sessions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_ladaco10_users CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_attachment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_condition_topics CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_forum CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_forum_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_message CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_message_rating CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_message_seq CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_report CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_timestamp CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lafrum11_tool_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lagmap10_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lagmap10_gmap CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lagmap10_marker CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lagmap10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lagmap10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_image_vote CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_imagegallery CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_imagegallery_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimag10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_commoncartridge CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_commoncartridge_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_item_instruction CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laimsc11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_comment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_kaltura CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_kaltura_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_rating CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lakalt11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lalead11_leaderselection CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lalead11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lalead11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_options_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_que_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_que_usr CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamc11_usr_attempt CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamind10_mindmap CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamind10_node CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamind10_request CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamind10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lamind10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lanb11_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lanb11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lanb11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lantbk11_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lantbk11_notebook CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lantbk11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lantbk11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lapixl10_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lapixl10_pixlr CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lapixl10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lapixl10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_condition_questions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_que_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_que_usr CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_usr_resp CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_wizard_category CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_wizard_cognitive_skill CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_laqa11_wizard_question CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_item_instruction CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_resource CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_resource_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_larsrc11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasbmt11_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasbmt11_report CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasbmt11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasbmt11_submission_details CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasbmt11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lascrb11_heading CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lascrb11_report_entry CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lascrb11_scribe CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasprd10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasprd10_spreadsheet CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasprd10_spreadsheet_mark CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasprd10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasprd10_user_modified_spreadsheet CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_answer CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_condition_questions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_option CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_question CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_survey CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lasurv11_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_condition CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_condition_tl_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_item_attachment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_item_comment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_item_log CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_tasklist CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_tasklist_item CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_latask10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_comment CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_conditions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_rating CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_recording CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lavidr10_videorecorder CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lavote11_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lavote11_nomination_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lavote11_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lavote11_usr CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lavote11_usr_attempt CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lawiki10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lawiki10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lawiki10_wiki CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE tl_lawiki10_wiki_page CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
								  MODIFY COLUMN title VARCHAR(191) NOT NULL;
ALTER TABLE tl_lawiki10_wiki_page_content CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lawook10_configuration CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lawook10_session CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lawook10_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- ALTER TABLE tl_lawook10_wookie CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Clean up after the major changes.
OPTIMIZE TABLE lams_activity_category;
OPTIMIZE TABLE lams_activity_evaluation;
OPTIMIZE TABLE lams_auth_method_type;
OPTIMIZE TABLE lams_authentication_method;
OPTIMIZE TABLE lams_branch_activity_entry;
OPTIMIZE TABLE lams_branch_condition;
OPTIMIZE TABLE lams_competence;
OPTIMIZE TABLE lams_competence_mapping;
OPTIMIZE TABLE lams_configuration;
OPTIMIZE TABLE lams_copy_type;
OPTIMIZE TABLE lams_cr_credential;
OPTIMIZE TABLE lams_cr_node;
OPTIMIZE TABLE lams_cr_node_version;
OPTIMIZE TABLE lams_cr_node_version_property;
OPTIMIZE TABLE lams_cr_workspace;
OPTIMIZE TABLE lams_cr_workspace_credential;
OPTIMIZE TABLE lams_data_flow;
OPTIMIZE TABLE lams_event_subscriptions;
OPTIMIZE TABLE lams_events;
OPTIMIZE TABLE lams_ext_course_class_map;
OPTIMIZE TABLE lams_ext_server_lesson_map;
OPTIMIZE TABLE lams_ext_server_org_map;
OPTIMIZE TABLE lams_ext_server_tool_map;
OPTIMIZE TABLE lams_ext_user_userid_map;
OPTIMIZE TABLE lams_gate_activity_level;
OPTIMIZE TABLE lams_gate_allowed_learners;
OPTIMIZE TABLE lams_gradebook_user_activity;
OPTIMIZE TABLE lams_gradebook_user_lesson;
OPTIMIZE TABLE lams_group;
OPTIMIZE TABLE lams_grouping;
OPTIMIZE TABLE lams_grouping_support_type;
OPTIMIZE TABLE lams_grouping_type;
OPTIMIZE TABLE lams_input_activity;
OPTIMIZE TABLE lams_learner_progress;
OPTIMIZE TABLE lams_learning_activity;
OPTIMIZE TABLE lams_learning_activity_type;
OPTIMIZE TABLE lams_learning_design;
OPTIMIZE TABLE lams_learning_design_access;
OPTIMIZE TABLE lams_learning_design_annotation;
OPTIMIZE TABLE lams_learning_library;
OPTIMIZE TABLE lams_learning_library_group;
OPTIMIZE TABLE lams_learning_library_to_group;
OPTIMIZE TABLE lams_learning_transition;
OPTIMIZE TABLE lams_lesson;
OPTIMIZE TABLE lams_lesson_dependency;
OPTIMIZE TABLE lams_lesson_state;
OPTIMIZE TABLE lams_license;
OPTIMIZE TABLE lams_log_event;
OPTIMIZE TABLE lams_log_event_type;
OPTIMIZE TABLE lams_notebook_entry;
OPTIMIZE TABLE lams_openid_config;
OPTIMIZE TABLE lams_organisation;
OPTIMIZE TABLE lams_organisation_group;
OPTIMIZE TABLE lams_organisation_grouping;
OPTIMIZE TABLE lams_organisation_state;
OPTIMIZE TABLE lams_organisation_type;
OPTIMIZE TABLE lams_password_request;
OPTIMIZE TABLE lams_planner_activity_metadata;
OPTIMIZE TABLE lams_planner_node_role;
OPTIMIZE TABLE lams_planner_nodes;
OPTIMIZE TABLE lams_planner_recent_learning_designs;
OPTIMIZE TABLE lams_presence_chat_msgs;
OPTIMIZE TABLE lams_presence_user;
OPTIMIZE TABLE lams_privilege;
OPTIMIZE TABLE lams_progress_attempted;
OPTIMIZE TABLE lams_progress_completed;
OPTIMIZE TABLE lams_qtz_blob_triggers;
OPTIMIZE TABLE lams_qtz_calendars;
OPTIMIZE TABLE lams_qtz_cron_triggers;
OPTIMIZE TABLE lams_qtz_fired_triggers;
OPTIMIZE TABLE lams_qtz_job_details;
OPTIMIZE TABLE lams_qtz_locks;
OPTIMIZE TABLE lams_qtz_paused_trigger_grps;
OPTIMIZE TABLE lams_qtz_scheduler_state;
OPTIMIZE TABLE lams_qtz_simple_triggers;
OPTIMIZE TABLE lams_qtz_simprop_triggers;
OPTIMIZE TABLE lams_qtz_triggers;
OPTIMIZE TABLE lams_rating;
OPTIMIZE TABLE lams_rating_comment;
OPTIMIZE TABLE lams_rating_criteria;
OPTIMIZE TABLE lams_rating_criteria_type;
OPTIMIZE TABLE lams_registration;
OPTIMIZE TABLE lams_role;
OPTIMIZE TABLE lams_role_privilege;
OPTIMIZE TABLE lams_signup_organisation;
OPTIMIZE TABLE lams_supported_locale;
OPTIMIZE TABLE lams_system_tool;
OPTIMIZE TABLE lams_text_search_condition;
OPTIMIZE TABLE lams_theme;
OPTIMIZE TABLE lams_timezone;
OPTIMIZE TABLE lams_tool;
OPTIMIZE TABLE lams_tool_content;
OPTIMIZE TABLE lams_tool_import_support;
OPTIMIZE TABLE lams_tool_session;
OPTIMIZE TABLE lams_tool_session_state;
OPTIMIZE TABLE lams_tool_session_type;
OPTIMIZE TABLE lams_user;
OPTIMIZE TABLE lams_user_disabled_tutorials;
OPTIMIZE TABLE lams_user_group;
OPTIMIZE TABLE lams_user_organisation;
OPTIMIZE TABLE lams_user_organisation_collapsed;
OPTIMIZE TABLE lams_user_organisation_group;
OPTIMIZE TABLE lams_user_organisation_role;
OPTIMIZE TABLE lams_wkspc_fld_content_type;
OPTIMIZE TABLE lams_wkspc_wkspc_folder;
OPTIMIZE TABLE lams_workspace;
OPTIMIZE TABLE lams_workspace_folder;
OPTIMIZE TABLE lams_workspace_folder_content;
OPTIMIZE TABLE lams_workspace_folder_type;
OPTIMIZE TABLE patches;
OPTIMIZE TABLE tl_eueadv10_condition;
OPTIMIZE TABLE tl_eueadv10_condition_expression;
OPTIMIZE TABLE tl_eueadv10_eadventure;
OPTIMIZE TABLE tl_eueadv10_item_log;
OPTIMIZE TABLE tl_eueadv10_param;
OPTIMIZE TABLE tl_eueadv10_session;
OPTIMIZE TABLE tl_eueadv10_user;
OPTIMIZE TABLE tl_eueadv10_var;
OPTIMIZE TABLE tl_laasse10_assessment;
OPTIMIZE TABLE tl_laasse10_assessment_overall_feedback;
OPTIMIZE TABLE tl_laasse10_assessment_question;
OPTIMIZE TABLE tl_laasse10_assessment_result;
OPTIMIZE TABLE tl_laasse10_assessment_unit;
OPTIMIZE TABLE tl_laasse10_option_answer;
OPTIMIZE TABLE tl_laasse10_question_option;
OPTIMIZE TABLE tl_laasse10_question_reference;
OPTIMIZE TABLE tl_laasse10_question_result;
OPTIMIZE TABLE tl_laasse10_session;
OPTIMIZE TABLE tl_laasse10_user;
OPTIMIZE TABLE tl_labbb10_bbb;
OPTIMIZE TABLE tl_labbb10_config;
OPTIMIZE TABLE tl_labbb10_session;
OPTIMIZE TABLE tl_labbb10_user;
OPTIMIZE TABLE tl_lachat11_chat;
OPTIMIZE TABLE tl_lachat11_conditions;
OPTIMIZE TABLE tl_lachat11_message;
OPTIMIZE TABLE tl_lachat11_session;
OPTIMIZE TABLE tl_lachat11_user;
OPTIMIZE TABLE tl_ladaco10_answer_options;
OPTIMIZE TABLE tl_ladaco10_answers;
OPTIMIZE TABLE tl_ladaco10_contents;
OPTIMIZE TABLE tl_ladaco10_questions;
OPTIMIZE TABLE tl_ladaco10_sessions;
OPTIMIZE TABLE tl_ladaco10_users;
OPTIMIZE TABLE tl_lafrum11_attachment;
OPTIMIZE TABLE tl_lafrum11_condition_topics;
OPTIMIZE TABLE tl_lafrum11_conditions;
OPTIMIZE TABLE tl_lafrum11_forum;
OPTIMIZE TABLE tl_lafrum11_forum_user;
OPTIMIZE TABLE tl_lafrum11_message;
OPTIMIZE TABLE tl_lafrum11_message_rating;
OPTIMIZE TABLE tl_lafrum11_message_seq;
OPTIMIZE TABLE tl_lafrum11_report;
OPTIMIZE TABLE tl_lafrum11_timestamp;
OPTIMIZE TABLE tl_lafrum11_tool_session;
OPTIMIZE TABLE tl_lagmap10_configuration;
OPTIMIZE TABLE tl_lagmap10_gmap;
OPTIMIZE TABLE tl_lagmap10_marker;
OPTIMIZE TABLE tl_lagmap10_session;
OPTIMIZE TABLE tl_lagmap10_user;
OPTIMIZE TABLE tl_laimag10_configuration;
OPTIMIZE TABLE tl_laimag10_image_vote;
OPTIMIZE TABLE tl_laimag10_imagegallery;
OPTIMIZE TABLE tl_laimag10_imagegallery_item;
OPTIMIZE TABLE tl_laimag10_item_log;
OPTIMIZE TABLE tl_laimag10_session;
OPTIMIZE TABLE tl_laimag10_user;
OPTIMIZE TABLE tl_laimsc11_commoncartridge;
OPTIMIZE TABLE tl_laimsc11_commoncartridge_item;
OPTIMIZE TABLE tl_laimsc11_configuration;
OPTIMIZE TABLE tl_laimsc11_item_instruction;
OPTIMIZE TABLE tl_laimsc11_item_log;
OPTIMIZE TABLE tl_laimsc11_session;
OPTIMIZE TABLE tl_laimsc11_user;
OPTIMIZE TABLE tl_lakalt11_comment;
OPTIMIZE TABLE tl_lakalt11_item_log;
OPTIMIZE TABLE tl_lakalt11_kaltura;
OPTIMIZE TABLE tl_lakalt11_kaltura_item;
OPTIMIZE TABLE tl_lakalt11_rating;
OPTIMIZE TABLE tl_lakalt11_session;
OPTIMIZE TABLE tl_lakalt11_user;
OPTIMIZE TABLE tl_lalead11_leaderselection;
OPTIMIZE TABLE tl_lalead11_session;
OPTIMIZE TABLE tl_lalead11_user;
OPTIMIZE TABLE tl_lamc11_content;
OPTIMIZE TABLE tl_lamc11_options_content;
OPTIMIZE TABLE tl_lamc11_que_content;
OPTIMIZE TABLE tl_lamc11_que_usr;
OPTIMIZE TABLE tl_lamc11_session;
OPTIMIZE TABLE tl_lamc11_usr_attempt;
OPTIMIZE TABLE tl_lamind10_mindmap;
OPTIMIZE TABLE tl_lamind10_node;
OPTIMIZE TABLE tl_lamind10_request;
OPTIMIZE TABLE tl_lamind10_session;
OPTIMIZE TABLE tl_lamind10_user;
OPTIMIZE TABLE tl_lanb11_content;
OPTIMIZE TABLE tl_lanb11_session;
OPTIMIZE TABLE tl_lanb11_user;
OPTIMIZE TABLE tl_lantbk11_conditions;
OPTIMIZE TABLE tl_lantbk11_notebook;
OPTIMIZE TABLE tl_lantbk11_session;
OPTIMIZE TABLE tl_lantbk11_user;
OPTIMIZE TABLE tl_lapixl10_configuration;
OPTIMIZE TABLE tl_lapixl10_pixlr;
OPTIMIZE TABLE tl_lapixl10_session;
OPTIMIZE TABLE tl_lapixl10_user;
OPTIMIZE TABLE tl_laqa11_condition_questions;
OPTIMIZE TABLE tl_laqa11_conditions;
OPTIMIZE TABLE tl_laqa11_configuration;
OPTIMIZE TABLE tl_laqa11_content;
OPTIMIZE TABLE tl_laqa11_que_content;
OPTIMIZE TABLE tl_laqa11_que_usr;
OPTIMIZE TABLE tl_laqa11_session;
OPTIMIZE TABLE tl_laqa11_usr_resp;
OPTIMIZE TABLE tl_laqa11_wizard_category;
OPTIMIZE TABLE tl_laqa11_wizard_cognitive_skill;
OPTIMIZE TABLE tl_laqa11_wizard_question;
OPTIMIZE TABLE tl_larsrc11_item_instruction;
OPTIMIZE TABLE tl_larsrc11_item_log;
OPTIMIZE TABLE tl_larsrc11_resource;
OPTIMIZE TABLE tl_larsrc11_resource_item;
OPTIMIZE TABLE tl_larsrc11_session;
OPTIMIZE TABLE tl_larsrc11_user;
OPTIMIZE TABLE tl_lasbmt11_content;
OPTIMIZE TABLE tl_lasbmt11_report;
OPTIMIZE TABLE tl_lasbmt11_session;
OPTIMIZE TABLE tl_lasbmt11_submission_details;
OPTIMIZE TABLE tl_lasbmt11_user;
OPTIMIZE TABLE tl_lascrb11_heading;
OPTIMIZE TABLE tl_lascrb11_report_entry;
OPTIMIZE TABLE tl_lascrb11_scribe;
OPTIMIZE TABLE tl_lascrb11_session;
OPTIMIZE TABLE tl_lascrb11_user;
OPTIMIZE TABLE tl_lascrt11_answer_log;
OPTIMIZE TABLE tl_lascrt11_burning_question;
OPTIMIZE TABLE tl_lascrt11_configuration;
OPTIMIZE TABLE tl_lascrt11_scratchie;
OPTIMIZE TABLE tl_lascrt11_scratchie_answer;
OPTIMIZE TABLE tl_lascrt11_scratchie_item;
OPTIMIZE TABLE tl_lascrt11_session;
OPTIMIZE TABLE tl_lascrt11_user;
OPTIMIZE TABLE tl_lasprd10_session;
OPTIMIZE TABLE tl_lasprd10_spreadsheet;
OPTIMIZE TABLE tl_lasprd10_spreadsheet_mark;
OPTIMIZE TABLE tl_lasprd10_user;
OPTIMIZE TABLE tl_lasprd10_user_modified_spreadsheet;
OPTIMIZE TABLE tl_lasurv11_answer;
OPTIMIZE TABLE tl_lasurv11_condition_questions;
OPTIMIZE TABLE tl_lasurv11_conditions;
OPTIMIZE TABLE tl_lasurv11_option;
OPTIMIZE TABLE tl_lasurv11_question;
OPTIMIZE TABLE tl_lasurv11_session;
OPTIMIZE TABLE tl_lasurv11_survey;
OPTIMIZE TABLE tl_lasurv11_user;
OPTIMIZE TABLE tl_latask10_condition;
OPTIMIZE TABLE tl_latask10_condition_tl_item;
OPTIMIZE TABLE tl_latask10_item_attachment;
OPTIMIZE TABLE tl_latask10_item_comment;
OPTIMIZE TABLE tl_latask10_item_log;
OPTIMIZE TABLE tl_latask10_session;
OPTIMIZE TABLE tl_latask10_tasklist;
OPTIMIZE TABLE tl_latask10_tasklist_item;
OPTIMIZE TABLE tl_latask10_user;
OPTIMIZE TABLE tl_lavidr10_comment;
OPTIMIZE TABLE tl_lavidr10_conditions;
OPTIMIZE TABLE tl_lavidr10_rating;
OPTIMIZE TABLE tl_lavidr10_recording;
OPTIMIZE TABLE tl_lavidr10_session;
OPTIMIZE TABLE tl_lavidr10_user;
OPTIMIZE TABLE tl_lavidr10_videorecorder;
OPTIMIZE TABLE tl_lavote11_content;
OPTIMIZE TABLE tl_lavote11_nomination_content;
OPTIMIZE TABLE tl_lavote11_session;
OPTIMIZE TABLE tl_lavote11_usr;
OPTIMIZE TABLE tl_lavote11_usr_attempt;
OPTIMIZE TABLE tl_lawiki10_session;
OPTIMIZE TABLE tl_lawiki10_user;
OPTIMIZE TABLE tl_lawiki10_wiki;
OPTIMIZE TABLE tl_lawiki10_wiki_page;
OPTIMIZE TABLE tl_lawiki10_wiki_page_content;
OPTIMIZE TABLE tl_lawook10_configuration;
OPTIMIZE TABLE tl_lawook10_session;
OPTIMIZE TABLE tl_lawook10_user;
OPTIMIZE TABLE tl_lawook10_wookie;

-- If there were no errors, commit and restore autocommit to on
SET FOREIGN_KEY_CHECKS=0;
COMMIT;
SET AUTOCOMMIT = 1;
