/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams;

import junit.framework.TestCase;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractLamsTestCase
extends TestCase {
    protected ApplicationContext context;
    private boolean shouldFlush = true;

    public AbstractLamsTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new ClassPathXmlApplicationContext(this.getContextConfigLocation());
        this.initializeHibernateSession();
    }

    protected abstract String[] getContextConfigLocation();

    protected void tearDown() throws Exception {
        super.tearDown();
        this.finalizeHibernateSession();
    }

    protected void initializeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean("coreSessionFactory");
        Session session = sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
    }

    protected void finalizeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean("coreSessionFactory");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (sessionHolder != null && this.shouldFlush) {
            Session session = sessionHolder.getSession();
            session.flush();
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            SessionFactoryUtils.closeSessionIfNecessary((Session)session, (SessionFactory)sessionFactory);
        }
    }

    protected Session getSession() {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean("coreSessionFactory");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (sessionHolder != null) {
            return sessionHolder.getSession();
        }
        return null;
    }

    public void setShouldFlush(boolean bl) {
        this.shouldFlush = bl;
    }
}

