/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Nullable;

public class Group
implements Serializable,
Nullable {
    public static final int STAFF_GROUP_ORDER_ID = 1;
    private Long groupId;
    private int orderId;
    private Grouping grouping;
    private Set users;
    private Set toolSessions;

    public Group(Long groupId, int orderId, Grouping grouping, Set users, Set toolSessions) {
        this.groupId = groupId;
        this.orderId = orderId;
        this.grouping = grouping;
        this.users = users;
        this.toolSessions = toolSessions;
    }

    public static Group createLearnerGroup(Grouping grouping, Set users) {
        return new Group(null, grouping.getNextGroupOrderId(), grouping, users, new HashSet());
    }

    public static Group createLearnerGroupWithToolSession(Grouping grouping, Set users, Set toolSessions) {
        return new Group(null, grouping.getNextGroupOrderId(), grouping, users, toolSessions);
    }

    public static Group createStaffGroup(Grouping grouping, Set staffs) {
        return new Group(null, 1, grouping, staffs, new HashSet());
    }

    public Group() {
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(Grouping grouping) {
        this.grouping = grouping;
    }

    public Set getUsers() {
        return this.users;
    }

    public void setUsers(Set userGroups) {
        this.users = userGroups;
    }

    public Set getToolSessions() {
        return this.toolSessions;
    }

    public void setToolSessions(Set toolSessions) {
        this.toolSessions = toolSessions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupId", (Object)this.getGroupId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        Group castOther = (Group)other;
        return new EqualsBuilder().append((Object)this.getGroupId(), (Object)castOther.getGroupId()).append(this.getOrderId(), castOther.getOrderId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGroupId()).append(this.getOrderId()).toHashCode();
    }

    public boolean hasLearner(User learner) {
        Iterator i = this.getUsers().iterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (user.getUserId().intValue() != learner.getUserId().intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isNull() {
        return false;
    }
}

