/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.HashSet;
import junit.framework.TestCase;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.usermanagement.User;

public class TestGrouping
extends TestCase {
    private Grouping grouping;

    protected void setUp() throws Exception {
        super.setUp();
        this.grouping = new RandomGrouping();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestGrouping(String string) {
        super(string);
    }

    public void testGetNextGroupOrderId() {
        TestGrouping.assertEquals((int)1, (int)this.grouping.getNextGroupOrderId());
        this.grouping.setGroups(new HashSet());
        Group group = new Group();
        group.setOrderId(this.grouping.getNextGroupOrderId());
        this.grouping.getGroups().add(group);
        TestGrouping.assertEquals((int)2, (int)this.grouping.getNextGroupOrderId());
        Group group2 = new Group();
        group2.setOrderId(this.grouping.getNextGroupOrderId());
        this.grouping.getGroups().add(group2);
        TestGrouping.assertEquals((int)3, (int)this.grouping.getNextGroupOrderId());
    }

    public void testGetLearners() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group);
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = new Group();
        this.insertUserIntoGroup(user2, group2);
        TestGrouping.assertEquals((String)"verify number of learners", (int)2, (int)this.grouping.getLearners().size());
    }

    public void testGetGroupByLearner() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group);
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = new Group();
        this.insertUserIntoGroup(user2, group2);
        Group group3 = this.grouping.getGroupBy(user2);
        TestGrouping.assertEquals((String)"verify group retrieved", (int)group2.getOrderId(), (int)group3.getOrderId());
    }

    public void testGetNullGroupByLearner() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group);
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = this.grouping.getGroupBy(user2);
        TestGrouping.assertTrue((String)"verify group retrieved", (boolean)group2.isNull());
    }

    private void insertUserIntoGroup(User user, Group group) {
        group.setUsers(new HashSet());
        group.getUsers().add(user);
        group.setOrderId(this.grouping.getNextGroupOrderId());
        this.grouping.getGroups().add(group);
    }
}

