/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.usermanagement.User;

public class ToolActivity
extends SimpleActivity
implements Serializable {
    private Long toolContentId;
    private Tool tool;
    private Set toolSessions;

    public ToolActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, String offlineInstructions, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Tool tool, Long toolContentId) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, offlineInstructions, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.tool = tool;
        this.toolContentId = toolContentId;
    }

    public ToolActivity() {
    }

    public ToolActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Tool tool, Long toolContentId) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.tool = tool;
        this.toolContentId = toolContentId;
    }

    public static ToolActivity createCopy(ToolActivity originalActivity) {
        ToolActivity newToolActivity = new ToolActivity();
        newToolActivity.setTool(originalActivity.getTool());
        newToolActivity.setToolContentId(originalActivity.getToolContentId());
        newToolActivity.setActivityUIID(originalActivity.getActivityUIID());
        newToolActivity.setDescription(originalActivity.getDescription());
        newToolActivity.setTitle(originalActivity.getTitle());
        newToolActivity.setHelpText(originalActivity.getHelpText());
        newToolActivity.setXcoord(originalActivity.getXcoord());
        newToolActivity.setYcoord(originalActivity.getYcoord());
        newToolActivity.setActivityTypeId(originalActivity.getActivityTypeId());
        newToolActivity.setGrouping(originalActivity.getGrouping());
        newToolActivity.setGroupingUIID(originalActivity.getGroupingUIID());
        newToolActivity.setOrderId(originalActivity.getOrderId());
        newToolActivity.setDefineLater(originalActivity.getDefineLater());
        newToolActivity.setLearningLibrary(originalActivity.getLearningLibrary());
        newToolActivity.setCreateDateTime(new Date());
        newToolActivity.setRunOffline(originalActivity.getRunOffline());
        newToolActivity.setOfflineInstructions(originalActivity.getOfflineInstructions());
        newToolActivity.setLibraryActivityUiImage(originalActivity.getLibraryActivityUiImage());
        newToolActivity.setLibraryActivity(originalActivity.getLibraryActivity());
        newToolActivity.setToolSessions(new HashSet());
        return newToolActivity;
    }

    public ToolSession createToolSessionForActivity(User learner, Lesson lesson) {
        if (this.getTool().getSupportsGrouping()) {
            return new GroupedToolSession(this, new Date(System.currentTimeMillis()), 1, this.getGroupFor(learner), lesson);
        }
        return new NonGroupedToolSession(this, new Date(System.currentTimeMillis()), 1, learner, lesson);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Set getToolSessions() {
        return this.toolSessions;
    }

    public void setToolSessions(Set toolSessions) {
        this.toolSessions = toolSessions;
    }

    public boolean isNull() {
        return false;
    }
}

