/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.Type;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.BaseDAO;

public class ActivityDAO
extends BaseDAO
implements IActivityDAO {
    private static final String TABLENAME = "lams_learning_activity";
    private static final String FIND_BY_PARENT = "from lams_learning_activity in class " + (class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity).getName() + " where parent_activity_id=?";
    private static final String FIND_BY_LEARNING_DESIGN_ID = "from lams_learning_activity in class " + (class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity).getName() + " where learning_design_id=?";
    private static final String FIND_BY_UI_ID = "from lams_learning_activity in class " + (class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity).getName() + " where activity_ui_id=?" + " AND " + " learning_design_id=?";
    private static final String FIND_BY_LIBRARY_ID = "from lams_learning_activity in class " + (class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity).getName() + " where learning_library_id=?" + " AND learning_design_id IS NULL";
    static /* synthetic */ Class class$org$lamsfoundation$lams$learningdesign$Activity;

    public Activity getActivityByActivityId(Long activityId) {
        return (Activity)super.find(class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity, activityId);
    }

    public List getActivitiesByParentActivityId(Long parentActivityId) {
        List list = this.getHibernateTemplate().find(FIND_BY_PARENT, (Object)parentActivityId);
        return list;
    }

    public List getAllActivities() {
        return super.findAll(class$org$lamsfoundation$lams$learningdesign$Activity == null ? (class$org$lamsfoundation$lams$learningdesign$Activity = ActivityDAO.class$("org.lamsfoundation.lams.learningdesign.Activity")) : class$org$lamsfoundation$lams$learningdesign$Activity);
    }

    public List getActivitiesByLearningDesignId(Long learningDesignId) {
        return this.getHibernateTemplate().find(FIND_BY_LEARNING_DESIGN_ID, (Object)learningDesignId);
    }

    public void insertActivity(Activity activity) {
        this.getHibernateTemplate().save((Object)activity);
    }

    public void insertOptActivity(OptionsActivity activity) {
        this.getHibernateTemplate().save((Object)activity);
    }

    public void updateActivity(Activity activity) {
        this.getHibernateTemplate().update((Object)activity);
    }

    public void deleteActivity(Activity activity) {
        this.getHibernateTemplate().delete((Object)activity);
    }

    public Activity getActivityByUIID(Integer id, LearningDesign design) {
        Long designID = design.getLearningDesignId();
        List list = this.getHibernateTemplate().find(FIND_BY_UI_ID, new Object[]{id, designID}, new Type[]{Hibernate.INTEGER, Hibernate.LONG});
        return (Activity)list.get(0);
    }

    public List getActivitiesByLibraryID(Long libraryID) {
        List list = this.getHibernateTemplate().find(FIND_BY_LIBRARY_ID, (Object)libraryID);
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

