/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;

public class LDAPAuthenticator {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$security$LDAPAuthenticator == null ? (class$org$lamsfoundation$lams$security$LDAPAuthenticator = LDAPAuthenticator.class$("org.lamsfoundation.lams.security.LDAPAuthenticator")) : class$org$lamsfoundation$lams$security$LDAPAuthenticator));
    private static final String USE_OBJECT_CREDENTIAL_OPT = "useObjectCredential";
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private AuthenticationMethod method;
    static /* synthetic */ Class class$org$lamsfoundation$lams$security$LDAPAuthenticator;

    public LDAPAuthenticator(AuthenticationMethod method) {
        this.method = method;
    }

    public boolean authenticate(String username, String inputPassword) {
        return this.authentication(username, inputPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authentication(String username, Object credential) {
        boolean bl;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.method.getParameterByName("java.naming.factory.initial").getValue());
        env.setProperty("java.naming.security.authentication", this.method.getParameterByName("java.naming.security.authentication").getValue());
        env.setProperty("java.naming.security.protocol", this.method.getParameterByName("java.naming.security.protocol").getValue());
        String principalDNPrefix = this.method.getParameterByName(PRINCIPAL_DN_PREFIX_OPT).getValue();
        String principalDNSuffix = this.method.getParameterByName(PRINCIPAL_DN_SUFFIX_OPT).getValue();
        String userDN = principalDNPrefix + username + principalDNSuffix;
        env.setProperty("java.naming.security.principal", userDN);
        env.setProperty("java.naming.provider.url", this.method.getParameterByName("java.naming.provider.url").getValue());
        env.put("java.naming.security.credentials", credential);
        String originalTrustStore = System.getProperty("javax.net.ssl.trustStore");
        String originalTrustPass = System.getProperty("javax.net.ssl.trustStorePassword");
        System.setProperty("javax.net.ssl.trustStore", this.method.getParameterByName("truststore.path").getValue());
        System.setProperty("javax.net.ssl.trustStorePassword", this.method.getParameterByName("truststore.password").getValue());
        log.debug((Object)("===> LDAP authenticator: " + env));
        InitialLdapContext ctx = null;
        try {
            try {
                ctx = new InitialLdapContext(env, null);
                log.debug((Object)("===> ldap context created: " + ctx));
                bl = true;
                Object var13_12 = null;
            }
            catch (Exception e) {
                log.error((Object)("===> Ldap exception: " + e));
                boolean bl2 = false;
                Object var13_13 = null;
                try {
                    if (ctx == null) return bl2;
                    ctx.close();
                    return bl2;
                }
                catch (Exception e2) {
                    log.error((Object)("===> gettting problem when closing context. Excetion: " + e2));
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {}
            catch (Exception e2) {
                log.error((Object)("===> gettting problem when closing context. Excetion: " + e2));
                throw throwable;
            }
            if (ctx == null) throw throwable;
            ctx.close();
            throw throwable;
        }
        try {}
        catch (Exception e2) {
            log.error((Object)("===> gettting problem when closing context. Excetion: " + e2));
            return bl;
        }
        if (ctx == null) return bl;
        ctx.close();
        return bl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

