/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool;

import java.util.Date;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dao.hibernate.LessonDAO;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolContentDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;

public class ToolDataAccessTestCase
extends AbstractLamsTestCase {
    protected IToolContentDAO toolContentDao;
    protected IToolDAO toolDao;
    protected IToolSessionDAO toolSessionDao;
    protected IUserDAO userDao;
    protected IActivityDAO activityDAO;
    protected IGroupDAO groupDao;
    protected ILessonDAO lessonDao;
    protected final Long TEST_TOOL_ID = new Long(6L);
    protected Tool testTool;
    protected ToolSession ngToolSession;
    protected ToolSession gToolSession;
    protected User testUser;
    protected Group testGroup;
    protected ToolActivity testNonGroupedActivity;
    protected ToolActivity testGroupedActivity;
    protected Lesson testLesson;
    private static final Integer TEST_USER_ID = new Integer(1);
    private static final Long TEST_NON_GROUP_ACTIVITY_ID = new Long(20L);
    private static final Long TEST_GROUPED_ACTIVITY_ID = new Long(19L);
    private static final Long TEST_GROUP_ID = new Long(88L);
    private static final Long TEST_GROUPING_ID = new Long(100L);
    public static final Long TEST_LESSON_ID = new Long(1L);

    protected void setUp() throws Exception {
        super.setUp();
        this.toolContentDao = (ToolContentDAO)this.context.getBean("toolContentDAO");
        this.toolDao = (ToolDAO)this.context.getBean("toolDAO");
        this.toolSessionDao = (ToolSessionDAO)this.context.getBean("toolSessionDAO");
        this.activityDAO = (ActivityDAO)this.context.getBean("activityDAO");
        this.userDao = (UserDAO)this.context.getBean("userDAO");
        this.groupDao = (GroupDAO)this.context.getBean("groupDAO");
        this.lessonDao = (LessonDAO)this.context.getBean("lessonDAO");
        this.testUser = this.userDao.getUserById(TEST_USER_ID);
        this.testNonGroupedActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(TEST_NON_GROUP_ACTIVITY_ID);
        this.testGroupedActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(TEST_GROUPED_ACTIVITY_ID);
        this.testGroup = this.groupDao.getGroupById(TEST_GROUP_ID);
        this.testLesson = this.lessonDao.getLesson(TEST_LESSON_ID);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ToolDataAccessTestCase(String string) {
        super(string);
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"/org/lamsfoundation/lams/lesson/lessonApplicationContext.xml", "/org/lamsfoundation/lams/tool/toolApplicationContext.xml", "/org/lamsfoundation/lams/learningdesign/learningDesignApplicationContext.xml", "applicationContext.xml"};
    }

    public void initTestToolSession() {
        this.ngToolSession = this.initNGToolSession();
        this.gToolSession = this.initGToolSession();
    }

    public ToolSession initNGToolSession() {
        return new NonGroupedToolSession(this.testNonGroupedActivity, new Date(System.currentTimeMillis()), 1, this.testUser, this.testLesson);
    }

    public ToolSession initGToolSession() {
        return new GroupedToolSession(this.testGroupedActivity, new Date(System.currentTimeMillis()), 1, this.testGroup, this.testLesson);
    }
}

