/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.List;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.service.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LamsToolService
implements ILamsToolService,
ApplicationContextAware {
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private IActivityDAO activityDAO;
    private ToolContentIDGenerator contentIDGenerator;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    public List getAllPotentialLearners(long toolContentID) throws LamsToolServiceException {
        return null;
    }

    public ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        ToolSession toolSession = activity.createToolSessionForActivity(learner, lesson);
        this.toolSessionDAO.saveToolSession(toolSession);
        return toolSession;
    }

    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        if (toolActivity.getGrouping() != null) {
            Group learnerGroup = toolActivity.getGrouping().getGroupBy(learner);
            if (learnerGroup.isNull()) {
                throw new LamsToolServiceException("Fail to get grouped tool session: No group found for this learner.");
            }
            return this.toolSessionDAO.getToolSessionByGroup(learnerGroup, toolActivity);
        }
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    public void notifyToolsToCreateSession(Long toolSessionId, ToolActivity activity) {
        ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity);
        sessionManager.createToolSession(toolSessionId, activity.getToolContentId());
    }

    public Long copyToolContent(ToolActivity toolActivity) {
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
        if (this.isSurvey(toolActivity)) {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity);
            contentManager.copyToolContent(toolActivity.getToolContentId(), newToolcontentID);
        }
        return newToolcontentID;
    }

    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    private Object findToolService(ToolActivity toolActivity) {
        return this.context.getBean(toolActivity.getTool().getServiceName());
    }

    private boolean isSurvey(ToolActivity toolActivity) {
        return toolActivity.getTool().getServiceName().equals("surveyService");
    }
}

