/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.web;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.usermanagement.util.AdminPreparer;
import org.lamsfoundation.lams.usermanagement.web.UserActionForm;
import org.lamsfoundation.lams.web.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UserAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$usermanagement$web$UserAction == null ? (class$org$lamsfoundation$lams$usermanagement$web$UserAction = UserAction.class$("org.lamsfoundation.lams.usermanagement.web.UserAction")) : class$org$lamsfoundation$lams$usermanagement$web$UserAction));
    private static WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
    private static UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
    static /* synthetic */ Class class$org$lamsfoundation$lams$usermanagement$web$UserAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors = new ActionErrors();
        UserActionForm userForm = (UserActionForm)form;
        Integer editUserId = null;
        Integer orgId = userForm.getOrgId();
        Organisation org = service.getOrganisationById(orgId);
        if (this.isCancelled(request)) {
            AdminPreparer.prepare(org, request, service);
            request.getSession(true).removeAttribute("UserActionForm");
            return mapping.findForward("admin");
        }
        if (errors.isEmpty()) {
            log.debug((Object)("Call update user, based on form data " + userForm.toMap().toString()));
            User user = new User();
            try {
                UserOrganisation userOrg;
                BeanUtils.copyProperties((Object)user, (Object)userForm.toMap());
                log.debug((Object)("Copied values " + user.toString()));
                String authMethodName = userForm.getAuthMethodName();
                user.setAuthenticationMethod(service.getAuthenticationMethodByName(authMethodName));
                service.saveOrUpdateUser(user);
                editUserId = user.getUserId();
                if (userForm.isCreateNew()) {
                    userOrg = new UserOrganisation();
                    userOrg.setUser(user);
                    userOrg.setOrganisation(org);
                    service.saveOrUpdateUserOrganisation(userOrg);
                } else {
                    userOrg = service.getUserOrganisation(user.getUserId(), orgId);
                }
                String[] roleNames = userForm.getRoleNames();
                log.debug((Object)("Rolenames from form: " + roleNames));
                ArrayList<Role> roles = new ArrayList<Role>();
                for (int i = 0; i < roleNames.length; ++i) {
                    Role role = service.getRoleByName(roleNames[i]);
                    roles.add(role);
                    UserOrganisationRole userOrgRole = new UserOrganisationRole();
                    userOrgRole.setUserOrganisation(userOrg);
                    userOrgRole.setRole(role);
                    service.saveOrUpdateUserOrganisationRole(userOrgRole);
                }
                AdminPreparer.prepare(org, request, service);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            if (mapping.getInput() != null) {
                return new ActionForward(mapping.getInput());
            }
            request.getSession(true).removeAttribute("UserActionForm");
            return mapping.findForward("error");
        }
        request.getSession(true).removeAttribute("UserActionForm");
        if (editUserId != null) {
            return mapping.findForward("admin");
        }
        return mapping.findForward("error");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

