/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.web;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.usermanagement.util.AdminPreparer;
import org.lamsfoundation.lams.usermanagement.web.UsersAddActionForm;
import org.lamsfoundation.lams.web.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UsersAddAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$usermanagement$web$UsersAddAction == null ? (class$org$lamsfoundation$lams$usermanagement$web$UsersAddAction = UsersAddAction.class$("org.lamsfoundation.lams.usermanagement.web.UsersAddAction")) : class$org$lamsfoundation$lams$usermanagement$web$UsersAddAction));
    private static WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
    private static UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
    public static final String SUBMIT_SHOW_USERS = "Show Users";
    public static final String SUBMIT_ADD_USERS = "Add Selected Users";
    static /* synthetic */ Class class$org$lamsfoundation$lams$usermanagement$web$UsersAddAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UsersAddActionForm dataForm = (UsersAddActionForm)form;
        if (this.isCancelled(request)) {
            Organisation org = service.getOrganisationById(dataForm.getOrgId());
            AdminPreparer.prepare(org, request, service);
            request.getSession(true).removeAttribute("UsersAddActionForm");
            return mapping.findForward("admin");
        }
        ActionErrors errors = new ActionErrors();
        Integer orgId = null;
        boolean finished = false;
        if (errors.isEmpty()) {
            try {
                log.debug((Object)("dataForm is " + (Object)((Object)dataForm)));
                orgId = dataForm.getOrgId();
                if (orgId == null || orgId == -1) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
                } else if (this.isShowUsers(request)) {
                    this.addUsersToForm(request, dataForm);
                } else {
                    this.addUsersToOrg(request, dataForm, errors);
                    finished = true;
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            request.getSession(true).removeAttribute("UsersAddActionForm");
            if (mapping.getInput() != null) {
                return new ActionForward(mapping.getInput());
            }
            return mapping.findForward("error");
        }
        if (finished) {
            request.getSession(true).removeAttribute("UsersAddActionForm");
            Organisation org = service.getOrganisationById(orgId);
            AdminPreparer.prepare(org, request, service);
            return mapping.findForward("admin");
        }
        return mapping.findForward("usersadd");
    }

    private void addUsersToOrg(HttpServletRequest request, UsersAddActionForm dataForm, ActionErrors errors) {
        Integer orgId = dataForm.getOrgId();
        Organisation org = service.getOrganisationById(orgId);
        String[] potentialRoleNames = dataForm.getPotentialRoleNames();
        String lastLogin = "";
        UserOrganisation lastUserOrg = null;
        for (int i = 0; i < potentialRoleNames.length; ++i) {
            int index = potentialRoleNames[i].indexOf("_");
            String login = potentialRoleNames[i].substring(0, index).trim();
            String roleName = potentialRoleNames[i].substring(index + 1).trim();
            if (!login.equals(lastLogin)) {
                UserOrganisation userOrg = new UserOrganisation();
                userOrg.setUser(service.getUserByLogin(login));
                userOrg.setOrganisation(org);
                service.saveOrUpdateUserOrganisation(userOrg);
                lastUserOrg = userOrg;
                lastLogin = login;
            }
            Role role = service.getRoleByName(roleName);
            UserOrganisationRole userOrgRole = new UserOrganisationRole();
            userOrgRole.setRole(role);
            userOrgRole.setUserOrganisation(lastUserOrg);
            service.saveOrUpdateUserOrganisationRole(userOrgRole);
        }
    }

    private void addUsersToForm(HttpServletRequest request, UsersAddActionForm dataForm) {
        Integer orgId = dataForm.getOrgId();
        Integer selectedOrgId = dataForm.getSelectedOrgId();
        HashMap potentialRoleNames = new HashMap();
        if (selectedOrgId != null) {
            List existingUsers = service.getUsersFromOrganisation(orgId);
            List users = service.getUsersFromOrganisation(selectedOrgId);
            if (users != null) {
                for (int i = 0; i < users.size(); ++i) {
                    User user = (User)users.get(i);
                    Iterator iter2 = existingUsers.iterator();
                    while (iter2.hasNext()) {
                        User existingUser = (User)iter2.next();
                        if (!user.getUserId().equals(existingUser.getUserId())) continue;
                        users.remove(i);
                    }
                }
                log.debug((Object)("Adding users to form " + users.toString()));
                dataForm.setPotentialRoleNames(new String[0]);
                dataForm.setPotentialUsers(users);
            }
        }
    }

    private boolean isShowUsers(HttpServletRequest request) {
        String submitValue = request.getParameter("submit");
        log.debug((Object)("Submit value is " + submitValue));
        return SUBMIT_SHOW_USERS.equals(submitValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

