/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;

public class WebUtil {
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_SESSION_STATUS = "sessionStatus";
    public static final String PARAM_TOOL_SESSION_ID = "sessionId";
    public static final String PARAM_CONTENT_ID = "content_id";
    public static final String PARAM_USER_ID = "user_id";
    public static final String PARAM_LESSON_ID = "lesson_id";
    public static final String ATTR_MODE = "mode";
    public static final String ATTR_USERNAME = "username";
    public static final String ATTR_UPDATE_PROGRESS_BAR = "updateProgressBar";
    public static final String ATTR_SESSION_STATUS = "sessionStatus";
    public static final String ATTR_LESSON_ID = "lesson_id";
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$util$WebUtil == null ? (class$org$lamsfoundation$lams$util$WebUtil = WebUtil.class$("org.lamsfoundation.lams.util.WebUtil")) : class$org$lamsfoundation$lams$util$WebUtil));
    static /* synthetic */ Class class$org$lamsfoundation$lams$util$WebUtil;

    public static boolean isTokenValid(HttpServletRequest req, String tokenName) {
        if (req.getSession() != null) {
            String valueSession = (String)req.getSession().getAttribute(tokenName);
            String valueRequest = req.getParameter(tokenName);
            log.debug((Object)("(Session Token) name : " + tokenName + " value : " + valueSession));
            log.debug((Object)("(Request Token) name : " + tokenName + " value : " + valueRequest));
            if (valueSession != null && valueRequest != null && valueSession.equals(valueRequest)) {
                return true;
            }
        }
        return false;
    }

    public static void saveTaskURL(HttpServletRequest req, String[] urls) {
        if (urls != null) {
            if (urls.length == 1) {
                req.setAttribute("urlA", (Object)urls[0]);
            } else if (urls.length == 2) {
                req.setAttribute("urlA", (Object)urls[0]);
                req.setAttribute("urlB", (Object)urls[1]);
            }
        }
    }

    public static void saveToken(HttpServletRequest req, String tokenName, String tokenValue) {
        if (req.getSession().getAttribute(tokenName) != null) {
            WebUtil.resetToken(req, tokenName);
        }
        req.getSession().setAttribute(tokenName, (Object)tokenValue);
        log.debug((Object)("(Save Session Token) name : " + tokenName + " value : " + tokenValue));
    }

    public static String retrieveToken(HttpServletRequest req, String tokenName) {
        return (String)req.getSession().getAttribute(tokenName);
    }

    public static void resetToken(HttpServletRequest req, String tokenName) {
        req.getSession().removeAttribute(tokenName);
    }

    public static void checkString(String paramName, String paramValue) throws IllegalArgumentException {
        if (paramValue == null || paramValue.length() < 1) {
            throw new IllegalArgumentException(paramName + " is required '" + paramValue + "'");
        }
    }

    public static int checkInteger(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Integer.parseInt(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be an integer '" + paramValue + "'");
        }
    }

    public static long checkLong(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Long.parseLong(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be a long '" + paramValue + "'");
        }
    }

    public static boolean checkBoolean(String paramName, String paramValue) throws IllegalArgumentException {
        WebUtil.checkString(paramName, paramValue);
        return Boolean.valueOf(paramValue.trim());
    }

    public static int readIntParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkInteger(paramName, req.getParameter(paramName));
    }

    public static int readIntParamFromUserSession(HttpServletRequest req, String paramName) {
        HttpSession session = req.getSession();
        if (session.getAttribute(paramName) != null) {
            return WebUtil.checkInteger(paramName, String.valueOf((Integer)session.getAttribute(paramName)));
        }
        return -1;
    }

    public static long readLongParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkLong(paramName, req.getParameter(paramName));
    }

    public static String readStrParam(HttpServletRequest req, String paramName) {
        return WebUtil.readStrParam(req, paramName, false);
    }

    public static String readStrParam(HttpServletRequest req, String paramName, boolean isOptional) {
        if (!isOptional) {
            WebUtil.checkString(paramName, req.getParameter(paramName));
        }
        return req.getParameter(paramName);
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName) throws IllegalArgumentException {
        return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName, boolean defaultValue) {
        try {
            return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static boolean readBooleanAttr(HttpServletRequest req, String attrName) {
        return WebUtil.checkBoolean(attrName, (String)req.getSession().getAttribute(attrName));
    }

    public static String getUsername(HttpServletRequest req) throws RuntimeException {
        Principal prin = req.getUserPrincipal();
        if (prin == null) {
            throw new RuntimeException("Trying to get username but principal object missing. Request is " + req.toString());
        }
        String username = prin.getName();
        if (username == null) {
            throw new RuntimeException("Name missing from principal object. Request is " + req.toString() + " Principal object is " + ((Object)prin).toString());
        }
        return username;
    }

    public static ToolAccessMode readToolAccessModeParam(HttpServletRequest request, String param_mode, boolean optional) {
        String mode = WebUtil.readStrParam(request, param_mode, optional);
        if (mode.equals(ToolAccessMode.AUTHOR.toString())) {
            return ToolAccessMode.AUTHOR;
        }
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            return ToolAccessMode.LEARNER;
        }
        if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            return ToolAccessMode.TEACHER;
        }
        throw new IllegalArgumentException("[" + mode + "] is not a legal mode" + "in LAMS");
    }

    public static String getStrutsForwardNameFromPath(String path) {
        String pathWithoutSlash = StringUtils.substringAfter((String)path, (String)"/");
        String orginalForwardName = StringUtils.substringBeforeLast((String)pathWithoutSlash, (String)".do");
        return StringUtils.uncapitalize((String)orginalForwardName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

