/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.usermanagement.util.AdminPreparer;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.HttpSessionManager;
import org.lamsfoundation.lams.web.PasswordChangeActionForm;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HomeAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$web$HomeAction == null ? (class$org$lamsfoundation$lams$web$HomeAction = HomeAction.class$("org.lamsfoundation.lams.web.HomeAction")) : class$org$lamsfoundation$lams$web$HomeAction));
    private static WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
    private static UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
    static /* synthetic */ Class class$org$lamsfoundation$lams$web$HomeAction;

    private boolean isUserInRole(String login, int orgId, String roleName) {
        return service.getUserOrganisationRole(login, new Integer(orgId), roleName) != null;
    }

    public ActionForward admin(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request admin");
            String login = req.getRemoteUser();
            int orgId = new Integer(req.getParameter("orgId"));
            if (this.isUserInRole(login, orgId, "ADMIN")) {
                log.debug((Object)"user is admin");
                Organisation org = service.getOrganisationById(new Integer(orgId));
                AdminPreparer.prepare(org, req, service);
                return mapping.findForward("admin");
            }
            log.error((Object)("User " + login + " tried to get admin screen but isn't admin in organisation: " + orgId));
            return mapping.findForward("error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("error");
        }
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request learner");
            String login = req.getRemoteUser();
            int orgId = new Integer(req.getParameter("orgId"));
            if (this.isUserInRole(login, orgId, "LEARNER")) {
                log.debug((Object)"user is learner");
                String serverUrl = Configuration.get(ConfigurationKeys.SERVER_URL);
                req.setAttribute("serverUrl", (Object)serverUrl);
                return mapping.findForward("learner");
            }
            log.error((Object)("User " + login + " tried to get learner screen but isn't learner in organisation: " + orgId));
            return mapping.findForward("error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("error");
        }
    }

    public ActionForward author(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request author");
            String login = req.getRemoteUser();
            int orgId = new Integer(req.getParameter("orgId"));
            if (this.isUserInRole(login, orgId, "AUTHOR")) {
                log.debug((Object)"user is author");
                String serverUrl = Configuration.get(ConfigurationKeys.SERVER_URL);
                req.setAttribute("serverUrl", (Object)serverUrl);
                return mapping.findForward("author");
            }
            log.error((Object)("User " + login + " tried to get author screen but isn't author in organisation: " + orgId));
            return mapping.findForward("error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("error");
        }
    }

    public ActionForward staff(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request staff");
            String login = req.getRemoteUser();
            int orgId = new Integer(req.getParameter("orgId"));
            if (this.isUserInRole(login, orgId, "STAFF")) {
                log.debug((Object)"user is staff");
                String serverUrl = Configuration.get(ConfigurationKeys.SERVER_URL);
                req.setAttribute("serverUrl", (Object)serverUrl);
                return mapping.findForward("staff");
            }
            log.error((Object)("User " + login + " tried to get staff screen but isn't staff in organisation: " + orgId));
            return mapping.findForward("error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("error");
        }
    }

    public ActionForward passwordChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String login = request.getRemoteUser();
        PasswordChangeActionForm newForm = new PasswordChangeActionForm();
        newForm.setLogin(login);
        request.getSession(true).setAttribute("PasswordChangeActionForm", (Object)newForm);
        return mapping.findForward("passwordChange");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

