/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ToolActivity;

public class GBActivityGridRowDTO
extends GradebookGridRowDTO {
    public static final String VIEW_USER = "userView";
    public static final String VIEW_ACTIVITY = "activityView";
    private String competences;
    private String output;
    private String activityUrl;
    private Date startDate;
    private String monitorUrl;
    private Long groupId;

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public GBActivityGridRowDTO(ToolActivity activity, String groupName, Long groupId) {
        if (groupName != null && groupId != null) {
            this.id = activity.getActivityId().toString() + "_" + groupId.toString();
            this.groupId = groupId;
            this.rowName = StringEscapeUtils.escapeHtml((String)activity.getTitle()) + " (" + groupName + ")";
        } else {
            this.id = activity.getActivityId().toString();
            this.rowName = StringEscapeUtils.escapeHtml((String)activity.getTitle());
        }
        Set competenceMappings = activity.getCompetenceMappings();
        String competenceMappingsStr = "";
        if (competenceMappings != null) {
            for (CompetenceMapping mapping : competenceMappings) {
                competenceMappingsStr = competenceMappingsStr + mapping.getCompetence().getTitle() + ", ";
            }
            if (competenceMappingsStr.length() > 0) {
                competenceMappingsStr = competenceMappingsStr.substring(0, competenceMappingsStr.lastIndexOf(","));
            }
        }
        this.competences = competenceMappingsStr;
    }

    @Override
    public ArrayList<String> toStringArray(GBGridView view) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.id.toString());
        if (view == GBGridView.MON_USER) {
            ret.add(this.marksAvailable != null ? this.marksAvailable.toString() : "");
            if (this.activityUrl != null && this.activityUrl.length() != 0) {
                ret.add("<a href='javascript:launchPopup(\"" + this.activityUrl + "\",\"" + this.rowName + "\",796,570)'>" + this.rowName + "</a>");
            } else {
                ret.add(this.rowName);
            }
            ret.add(this.status);
            ret.add(this.output != null ? this.output.toString() : "-");
            ret.add(this.competences);
            ret.add(this.startDate != null ? this.convertDateToString(this.startDate, DEFAULT_DATE_FORMAT) : "-");
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.feedback);
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark) : "-");
        } else if (view == GBGridView.MON_ACTIVITY) {
            ret.add(this.groupId != null ? this.groupId.toString() : "");
            if (this.monitorUrl != null && this.monitorUrl.length() != 0) {
                ret.add("<a href='javascript:launchPopup(\"" + this.monitorUrl + "\",\"" + this.rowName + "\",796,570)'>" + this.rowName + "</a>");
            } else {
                ret.add(this.rowName);
            }
            ret.add(this.averageTimeTaken != null ? this.convertTimeToString(this.averageTimeTaken) : "-");
            ret.add(this.competences);
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark) : "-");
        } else if (view == GBGridView.LRN_ACTIVITY) {
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.feedback);
            ret.add(this.averageTimeTaken != null ? this.convertTimeToString(this.averageTimeTaken) : "-");
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.averageMark != null ? GradebookUtil.niceFormatting(this.averageMark) : "-");
            ret.add(this.mark != null ? GradebookUtil.niceFormatting(this.mark) : "-");
        }
        return ret;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getCompetences() {
        return this.competences;
    }

    public void setCompetences(String competences) {
        this.competences = competences;
    }

    public String getActivityUrl() {
        return this.activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getMonitorUrl() {
        return this.monitorUrl;
    }

    public void setMonitorUrl(String monitorUrl) {
        this.monitorUrl = monitorUrl;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
}

