/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dto;

import java.util.Date;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LessonDetailsDTO {
    private Long lessonID;
    private Integer lessonStateID;
    private Date createDateTime;
    private Date startDateTime;
    private Long duration;
    private Integer organisationID;
    private String organisationName;
    private String organisationDescription;
    private Integer workspaceFolderID;
    private Long licenseID;
    private String licenseText;
    private Long learningDesignID;

    public LessonDetailsDTO(Long lessonID, Long duration, Date createDateTime, Date startDateTime, Integer organisationID, String organisationName, String organisationDescription, Integer workspaceFolderID, Long licenseID, String licenseText, Integer lessonStateID, Long learningDesignID) {
        this.lessonID = lessonID;
        this.duration = duration;
        this.createDateTime = createDateTime;
        this.startDateTime = startDateTime;
        this.organisationID = organisationID;
        this.organisationName = organisationName;
        this.organisationDescription = organisationDescription;
        this.workspaceFolderID = workspaceFolderID;
        this.licenseID = licenseID;
        this.licenseText = licenseText;
        this.lessonStateID = lessonStateID;
        this.learningDesignID = learningDesignID;
    }

    public LessonDetailsDTO(Lesson lesson) {
        this.lessonID = lesson.getLessonId();
        this.duration = lesson.getLearningDesign().getDuration();
        this.createDateTime = lesson.getCreateDateTime();
        this.startDateTime = lesson.getStartDateTime();
        this.organisationID = lesson.getOrganisation() != null ? lesson.getOrganisation().getOrganisationId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.organisationName = lesson.getOrganisation() != null ? lesson.getOrganisation().getName() : "string_null_value";
        this.organisationDescription = lesson.getOrganisation() != null ? lesson.getOrganisation().getDescription() : "string_null_value";
        this.workspaceFolderID = lesson.getLearningDesign().getWorkspaceFolder() != null ? lesson.getLearningDesign().getWorkspaceFolder().getWorkspaceFolderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.licenseID = lesson.getLearningDesign().getLicense() != null ? lesson.getLearningDesign().getLicense().getLicenseID() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.licenseText = lesson.getLearningDesign().getLicenseText() != null ? lesson.getLearningDesign().getLicenseText() : "string_null_value";
        this.lessonStateID = lesson.getLessonStateId();
        this.learningDesignID = lesson.getLearningDesign().getLearningDesignId();
    }

    public Date getCreateDateTime() {
        return this.createDateTime != null ? this.createDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getDuration() {
        return this.duration != null ? this.duration : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID != null ? this.learningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLessonID() {
        return this.lessonID != null ? this.lessonID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getLessonStateID() {
        return this.lessonStateID != null ? this.lessonStateID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getLicenseID() {
        return this.licenseID != null ? this.licenseID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLicenseText() {
        return this.licenseText != null ? this.licenseText : "string_null_value";
    }

    public String getOrganisationDescription() {
        return this.organisationDescription != null ? this.organisationDescription : "string_null_value";
    }

    public Integer getOrganisationID() {
        return this.organisationID != null ? this.organisationID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getOrganisationName() {
        return this.organisationName != null ? this.organisationName : "string_null_value";
    }

    public Date getStartDateTime() {
        return this.startDateTime != null ? this.startDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID != null ? this.workspaceFolderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }
}

