/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.dto;

import java.util.Hashtable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.themes.CSSStyle;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dto.CSSStyleDTO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

public class CSSVisualElementDTO
extends BaseDTO {
    protected Logger log = Logger.getLogger(CSSVisualElementDTO.class);
    private String name;
    private CSSStyleDTO styleObject;

    public CSSVisualElementDTO(Hashtable wddxData) throws WDDXProcessorConversionException {
        if (wddxData != null) {
            this.name = WDDXProcessor.convertToString(wddxData, "name");
            Hashtable so = (Hashtable)wddxData.get("styleObject");
            if (so != null) {
                this.styleObject = new CSSStyleDTO(so);
            }
        }
    }

    public CSSVisualElementDTO(CSSThemeVisualElement visualElement) {
        if (visualElement != null) {
            this.name = visualElement.getName();
            CSSStyle style = visualElement.getStyle();
            if (style != null) {
                this.styleObject = new CSSStyleDTO(style);
            }
        }
    }

    public CSSThemeVisualElement createCSSThemeVisualElement() {
        CSSThemeVisualElement visualElement = new CSSThemeVisualElement();
        visualElement.setName(this.name);
        visualElement.setStyle(this.styleObject.createNewCSSStyle());
        visualElement.setTheme(false);
        return visualElement;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("styleObject", (Object)this.styleObject).toString();
    }

    public String getName() {
        return this.name;
    }

    public CSSStyleDTO getStyleObject() {
        return this.styleObject;
    }
}

