/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.util;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class AdminPreparer {
    private static Logger log = Logger.getLogger(AdminPreparer.class);

    public static void prepare(Organisation org, HttpServletRequest request, UserManagementService service) {
        UserOrganisationRole userOrgRole = null;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            log.error((Object)"Unable to prepare for admin as user is not in the shared session");
        } else {
            if (org.getParentOrganisation() != null) {
                userOrgRole = service.getUserOrganisationRole(user.getUserID(), org.getParentOrganisation().getOrganisationId(), "ADMIN");
            }
            List childOrgs = service.getChildOrganisations(org);
            for (int i = 0; i < childOrgs.size(); ++i) {
                Organisation childOrg = (Organisation)childOrgs.get(i);
                if (service.getUserOrganisationRole(user.getUserID(), childOrg.getOrganisationId(), "ADMIN") != null) continue;
                childOrgs.remove(i);
            }
            if (childOrgs.size() != 0) {
                HashSet childOrganisations = new HashSet();
                childOrganisations.addAll(childOrgs);
                org.setChildOrganisations(childOrganisations);
            } else {
                org.setChildOrganisations(null);
            }
            request.setAttribute("organisation", (Object)org);
            if (userOrgRole != null) {
                request.setAttribute("parentAccess", (Object)"true");
            }
        }
    }
}

