/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtilException;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);
    protected static final String prefix = "lamstmp_";
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");

    public static boolean deleteDirectory(File directory) {
        boolean retValue = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtil.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                log.error((Object)("Unable to delete file " + file.getName()));
                retValue = false;
            }
        }
        if (directory.delete()) {
            return retValue;
        }
        return false;
    }

    public static boolean deleteDirectory(String directoryName) throws FileUtilException {
        boolean isDeleted = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isDeleted = FileUtil.deleteDirectory(dir);
        return isDeleted;
    }

    public static String createTempDirectory(String suffix) throws FileUtilException {
        String tempSysDirName = TEMP_DIR;
        if (tempSysDirName == null) {
            throw new FileUtilException("No temporary directory known to the server. [System.getProperty( \"java.io.tmpdir\" ) returns null. ]\n Cannot upload package.");
        }
        String tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + suffix;
        File tempDir = new File(tempDirName);
        int i = 0;
        while (tempDir.exists() && i < 100) {
            tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + i + suffix;
            tempDir = new File(tempDirName);
        }
        if (tempDir.exists()) {
            throw new FileUtilException("Unable to create temporary directory. The temporary filename/directory that we would use to extract files already exists: " + tempDirName);
        }
        tempDir.mkdirs();
        return tempDirName;
    }

    public static boolean createDirectory(String directoryName) throws FileUtilException {
        boolean isCreated = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isCreated = dir.exists() ? false : dir.mkdirs();
        return isCreated;
    }

    public static boolean createDirectory(String parentDirName, String subDirName) throws FileUtilException {
        String combinedDirName;
        boolean isSubDirCreated = false;
        if (parentDirName == null || parentDirName.length() == 0 || subDirName == null || subDirName.length() == 0) {
            throw new FileUtilException("A parent or subdirectory name must be specified");
        }
        File parentDir = new File(parentDirName);
        boolean isParentDirCreated = !parentDir.exists() ? FileUtil.createDirectory(parentDirName) : true;
        if (FileUtil.trailingForwardSlashPresent(parentDirName)) {
            parentDirName = FileUtil.removeTrailingForwardSlash(parentDirName);
        }
        return (isSubDirCreated = FileUtil.createDirectory(combinedDirName = parentDirName + File.separator + subDirName)) && isParentDirCreated;
    }

    public static String removeTrailingForwardSlash(String stringToModify) {
        String stringWithoutSlashAtEnd = stringToModify.substring(0, stringToModify.length() - 1);
        return stringWithoutSlashAtEnd;
    }

    public static boolean trailingForwardSlashPresent(String stringToCheck) {
        int indexOfSlash = stringToCheck.lastIndexOf("/");
        return indexOfSlash == stringToCheck.length() - 1;
    }

    public static boolean directoryExist(String directoryToCheck) {
        File dir = new File(directoryToCheck);
        return dir.exists();
    }

    private static String generateDumpFilename(String id, String extension) throws FileUtilException {
        String dumpDirectory = Configuration.get(ConfigurationKeys.LAMS_DUMP_DIR);
        if (dumpDirectory == null) {
            dumpDirectory = TEMP_DIR;
        }
        FileUtil.createDirectory(dumpDirectory);
        String dumpFilename = dumpDirectory + File.separator + id + System.currentTimeMillis() + (extension != null ? "." + extension : "");
        File dumpFile = new File(dumpFilename);
        int i = 0;
        while (dumpFile.exists() && i < 100) {
            dumpFilename = dumpDirectory + File.separator + id + System.currentTimeMillis() + "_" + i + (extension != null ? "." + extension : "");
            dumpFile = new File(dumpFilename);
        }
        if (dumpFile.exists()) {
            throw new FileUtilException("Unable to create dump file. The filename that we would use already exists: " + dumpFile);
        }
        return dumpFilename;
    }

    public static String createDumpFile(byte[] data, String id, String extension) throws FileUtilException {
        String dumpFilename = FileUtil.generateDumpFilename(id, extension);
        FileOutputStream dumpFile = null;
        try {
            dumpFile = new FileOutputStream(dumpFilename);
            ((OutputStream)dumpFile).write(data);
        }
        catch (IOException e) {
            log.error((Object)("Unable to write dump out byte array to dump file. ID: " + id + " Dump: " + data + " Exception " + e.getMessage()), (Throwable)e);
            throw new FileUtilException(e);
        }
        finally {
            try {
                if (dumpFile != null) {
                    ((OutputStream)dumpFile).close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Unable to close dump file. ID: " + id + " Dump: " + data + " Exception " + e.getMessage()), (Throwable)e);
                throw new FileUtilException(e);
            }
        }
        return dumpFilename;
    }
}

