/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learning.export.ActivityPortfolio;
import org.lamsfoundation.lams.learning.export.ExportPortfolioConstants;
import org.lamsfoundation.lams.learning.export.ExportPortfolioException;
import org.lamsfoundation.lams.learning.export.NotebookPortfolio;
import org.lamsfoundation.lams.learning.export.Portfolio;
import org.lamsfoundation.lams.learning.export.service.IExportPortfolioService;
import org.lamsfoundation.lams.learning.export.service.PortfolioBuilder;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.HttpUrlConnectionUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPortfolioService
implements IExportPortfolioService {
    private static Logger log = Logger.getLogger(ExportPortfolioService.class);
    private ILamsCoreToolService lamsCoreToolService;
    private ICoreNotebookService coreNotebookService;
    private IActivityDAO activityDAO;
    private ICoreLearnerService learnerService;
    private IBaseDAO baseDAO;
    private ILessonDAO lessonDAO;
    protected MessageService messageService;
    private IThemeService themeService;

    public void setLearnerService(ICoreLearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setThemeService(IThemeService themeService) {
        this.themeService = themeService;
    }

    @Override
    public Portfolio exportPortfolioForTeacher(Long lessonId, Cookie[] cookies) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        ArrayList<ActivityPortfolio> portfolios = null;
        Portfolio exports = null;
        if (lesson != null) {
            try {
                PortfolioBuilder builder = new PortfolioBuilder(lesson.getLearningDesign(), this.activityDAO, this.lamsCoreToolService, this.coreNotebookService, ToolAccessMode.TEACHER, lesson, null, null);
                builder.parseLearningDesign();
                portfolios = builder.getPortfolioList();
                exports = this.doExport(portfolios, null, cookies, lesson);
            }
            catch (LamsToolServiceException e) {
                throw new ExportPortfolioException("An exception has occurred while generating portfolios. The error is: " + (Object)((Object)e));
            }
        } else {
            String error = "The Lesson with lessonID " + lessonId + "is null.";
            log.error((Object)error);
            exports = this.createPortfolioIndicatingErrorHasOccurred(lesson);
        }
        return exports;
    }

    @Override
    public Portfolio exportPortfolioForStudent(Integer userId, Long lessonID, boolean anonymity, ToolAccessMode accessMode, Cookie[] cookies) {
        Lesson lesson;
        Portfolio exports;
        block8: {
            ArrayList<ActivityPortfolio> portfolios = null;
            ArrayList<NotebookPortfolio> notes = null;
            exports = null;
            User learner = (User)this.baseDAO.find(User.class, (Serializable)userId);
            lesson = this.lessonDAO.getLesson(lessonID);
            if (learner != null) {
                LearnerProgress learnerProgress = this.learnerService.getProgress(learner.getUserId(), lessonID);
                if (learnerProgress != null) {
                    try {
                        PortfolioBuilder builder = new PortfolioBuilder(lesson.getLearningDesign(), this.activityDAO, this.lamsCoreToolService, this.coreNotebookService, ToolAccessMode.LEARNER, lesson, learnerProgress, learner);
                        builder.parseLearningDesign();
                        builder.processNotebook(accessMode);
                        portfolios = builder.getPortfolioList();
                        notes = builder.getNotebookList();
                        if (portfolios.size() >= 0) {
                            exports = this.doExport(portfolios, notes, cookies, lesson);
                            exports.setLearnerName(learner.getFirstName() + " " + learner.getLastName() + " (" + learner.getLogin() + ")");
                            break block8;
                        }
                        log.error((Object)"The learner has not completed or attempted any activities");
                    }
                    catch (LamsToolServiceException e) {
                        log.error((Object)"An exception has occurred while generating portfolios.", (Throwable)e);
                    }
                } else {
                    log.error((Object)("The LearnerProgress cannot be found for userId " + userId + " participating in lessonId " + lessonID));
                }
            } else {
                log.error((Object)("The User object with userId" + userId + "or Lesson object with lessonId" + lessonID + " is null. Cannot Continue"));
            }
        }
        if (exports == null) {
            exports = this.createPortfolioIndicatingErrorHasOccurred(lesson);
        }
        return exports;
    }

    private Portfolio createPortfolioIndicatingErrorHasOccurred(Lesson lesson) {
        String tempDir = this.createDirectory("export");
        File dir = new File(tempDir);
        String exportID = dir.getName();
        Portfolio dummyPortfolio = new Portfolio(exportID);
        dummyPortfolio.setExportTmpDir(tempDir);
        dummyPortfolio.setLessonDescription(lesson.getLessonDescription());
        dummyPortfolio.setLessonName(lesson.getLessonName());
        return dummyPortfolio;
    }

    @Override
    public String zipPortfolio(String filename, String directoryToZip) {
        String dirToPutZip;
        try {
            dirToPutZip = FileUtil.createTempDirectory((String)"exportZipFile");
            String zipfileName = ZipFileUtil.createZipFile((String)filename, (String)directoryToZip, (String)dirToPutZip);
        }
        catch (FileUtilException e) {
            throw new ExportPortfolioException("Cannot create the temporary directory for this export", e);
        }
        catch (ZipFileUtilException e) {
            throw new ExportPortfolioException("An error has occurred while zipping up the directory ", e);
        }
        int index = dirToPutZip.lastIndexOf(File.separator);
        return index > -1 ? dirToPutZip.substring(index + 1) : dirToPutZip;
    }

    public Portfolio doExport(ArrayList<ActivityPortfolio> portfolios, ArrayList<NotebookPortfolio> notes, Cookie[] cookies, Lesson lesson) {
        Set competences;
        String tempDirectoryName = this.createDirectory("export");
        File dir = new File(tempDirectoryName);
        String exportID = dir.getName();
        Portfolio portfolio = new Portfolio(exportID);
        portfolio.setExportTmpDir(tempDirectoryName);
        portfolio.setContentFolderID(lesson.getLearningDesign().getContentFolderID());
        portfolio.setLessonName(lesson.getLessonName());
        portfolio.setLessonDescription(lesson.getLessonDescription());
        portfolio.setLessonStartDate(lesson.getStartDateTime());
        if (portfolios != null) {
            this.processPortfolios(portfolios, cookies, tempDirectoryName);
            portfolio.setActivityPortfolios(portfolios.toArray(new ActivityPortfolio[portfolios.size()]));
        }
        if (notes != null) {
            this.processNotes(notes, tempDirectoryName, portfolio);
            portfolio.setNotebookPortfolios(notes.toArray(new NotebookPortfolio[notes.size()]));
        }
        if ((competences = lesson.getLearningDesign().getCompetences()) != null) {
            portfolio.getCompetencesDefined().addAll(competences);
        }
        return portfolio;
    }

    private void processPortfolios(List portfolios, Cookie[] cookies, String tempDirectoryName) {
        for (ActivityPortfolio activityPortfolio : portfolios) {
            String subDirectoryName = "Activity" + activityPortfolio.getActivityId().toString();
            if (!this.createSubDirectory(tempDirectoryName, subDirectoryName)) {
                throw new ExportPortfolioException("The subdirectory " + subDirectoryName + " could not be created.");
            }
            String activitySubDirectory = tempDirectoryName + File.separator + subDirectoryName;
            String relativePath = activitySubDirectory.substring(FileUtil.TEMP_DIR.length() + 1, activitySubDirectory.length());
            if (!activityPortfolio.isHeadingNoPage()) {
                activityPortfolio.setExportUrl(ExportPortfolioConstants.HOST + activityPortfolio.getExportUrl());
                activityPortfolio.setExportUrl(WebUtil.appendParameterToURL((String)activityPortfolio.getExportUrl(), (String)"directoryName", (String)relativePath));
                String mainFileName = this.connectToToolViaExportURL(activityPortfolio.getActivityName(), activityPortfolio.getExportUrl(), cookies, activitySubDirectory);
                String toolLink = subDirectoryName + "/" + mainFileName;
                activityPortfolio.setToolLink(toolLink);
            }
            if (activityPortfolio.getChildPortfolios() == null || activityPortfolio.getChildPortfolios().size() <= 0) continue;
            this.processPortfolios(activityPortfolio.getChildPortfolios(), cookies, tempDirectoryName);
        }
    }

    private void processNotes(List notes, String tempDirectoryName, Portfolio portfolio) {
        if (notes.size() > 0) {
            String subDirectoryName = "Notebook";
            if (!this.createSubDirectory(tempDirectoryName, subDirectoryName)) {
                throw new ExportPortfolioException("The subdirectory " + subDirectoryName + " could not be created.");
            }
            File dir = new File(tempDirectoryName, subDirectoryName);
            portfolio.setNotebookDir(dir.getAbsolutePath());
            String mainFileName = "notebook_main.html";
            String notebookLink = subDirectoryName + "/" + mainFileName;
            portfolio.setNotebookLink(notebookLink);
        }
    }

    private boolean createSubDirectory(String parentDir, String subDir) {
        boolean created;
        try {
            created = FileUtil.createDirectory((String)parentDir, (String)subDir);
        }
        catch (FileUtilException e) {
            throw new ExportPortfolioException("An error has occurred while creating the sub directory " + subDir);
        }
        return created;
    }

    private String createDirectory(String name) {
        String tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)name);
        }
        catch (FileUtilException e) {
            throw new ExportPortfolioException("Unable to create temporary directory " + name + " for export.", e);
        }
        return tmpDir;
    }

    public String connectToToolViaExportURL(String activityName, String exportURL, Cookie[] cookies, String directoryToStoreErrorFile) {
        String filename = null;
        try {
            if (exportURL != null) {
                filename = HttpUrlConnectionUtil.connectToToolExportURL((String)exportURL, (Cookie[])cookies);
            }
            if (filename == null) {
                filename = "export_error.html";
                log.error((Object)"A problem has occurred while connecting to the tool's export url. The export url may be invalid or may not exist");
                this.writeErrorMessageToFile(directoryToStoreErrorFile, activityName);
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("The URL " + exportURL + " given is invalid."), (Throwable)e);
            this.writeErrorMessageToFile(directoryToStoreErrorFile, activityName);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("The directory " + directoryToStoreErrorFile + " may not exist."), (Throwable)e);
            this.writeErrorMessageToFile(directoryToStoreErrorFile, activityName);
        }
        catch (IOException e) {
            log.error((Object)("A problem has occurred while writing the contents of " + exportURL + " to file."), (Throwable)e);
            this.writeErrorMessageToFile(directoryToStoreErrorFile, activityName);
        }
        return filename;
    }

    @Override
    public void generateMainPage(HttpServletRequest request, Portfolio portfolio, Cookie[] cookies) {
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String url = basePath + "/exportPortfolio/main.jsp";
        String filename = "export_main.html";
        try {
            request.getSession().setAttribute("portfolio", (Object)portfolio);
            HttpUrlConnectionUtil.writeResponseToFile((String)url, (String)portfolio.getExportTmpDir(), (String)filename, (Cookie[])cookies);
            request.getSession().removeAttribute("portfolio");
        }
        catch (MalformedURLException e) {
            log.error((Object)("The URL given is invalid. Exception Message was: " + e));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("The directory or file may not exist. Exception Message was: " + e));
        }
        catch (IOException e) {
            log.error((Object)("A problem has occurred while writing the contents of " + url + " to file. Exception Message was: " + e));
        }
    }

    @Override
    public void generateNotebookPage(HttpServletRequest request, Portfolio portfolio, Cookie[] cookies) {
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String url = basePath + "/exportPortfolio/notebook.jsp";
        String filename = "notebook_main.html";
        try {
            request.getSession().setAttribute("portfolio", (Object)portfolio);
            HttpUrlConnectionUtil.writeResponseToFile((String)url, (String)portfolio.getNotebookDir(), (String)filename, (Cookie[])cookies);
            request.getSession().removeAttribute("portfolio");
        }
        catch (MalformedURLException e) {
            log.error((Object)("The URL given is invalid. Exception Message was: " + e));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("The directory or file may not exist. Exception Message was: " + e));
        }
        catch (IOException e) {
            log.error((Object)("A problem has occurred while writing the contents of " + url + " to file. Exception Message was: " + e));
        }
    }

    private void writeErrorMessageToFile(String directoryToStoreFile, String activityTitle) {
        try {
            String errorMessage = this.messageService.getMessage("error.export.portfolio.not.supported", new Object[]{activityTitle});
            String filepath = directoryToStoreFile + File.separator + "export_error.html";
            BufferedWriter fileout = new BufferedWriter(new FileWriter(filepath));
            fileout.write(errorMessage);
            fileout.close();
        }
        catch (IOException e) {
            log.error((Object)"Exception occured trying to write out error message to file.", (Throwable)e);
        }
    }

    @Override
    public Collection<CSSThemeVisualElement> getUserThemes() {
        List themeNames = CSSThemeUtil.getAllUserThemes((String)CSSThemeUtil.DEFAULT_HTML_THEME);
        HashSet<CSSThemeVisualElement> userThemes = new HashSet<CSSThemeVisualElement>();
        for (String themeName : themeNames) {
            CSSThemeVisualElement theme = this.themeService.getTheme(themeName);
            if (theme == null) continue;
            userThemes.add(theme);
        }
        return userThemes;
    }
}

