/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.export.ActivityPortfolio;
import org.lamsfoundation.lams.learning.export.ExportPortfolioException;
import org.lamsfoundation.lams.learning.export.NotebookPortfolio;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ISystemToolActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignProcessor;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortfolioBuilder
extends LearningDesignProcessor {
    private static Logger log = Logger.getLogger(PortfolioBuilder.class);
    ArrayList<ActivityPortfolio> mainPortfolioList = new ArrayList();
    ArrayList<NotebookPortfolio> mainNotebookList = new ArrayList();
    ArrayStack activityListStack;
    ArrayList<ActivityPortfolio> currentPortfolioList = this.mainPortfolioList;
    ArrayList<NotebookPortfolio> currentNotebookList = this.mainNotebookList;
    ToolAccessMode accessMode;
    ILamsCoreToolService lamsCoreToolService;
    ICoreNotebookService coreNotebookService;
    User user;
    LearnerProgress progress;
    Lesson lesson;

    public PortfolioBuilder(LearningDesign design, IActivityDAO activityDAO, ILamsCoreToolService lamsCoreToolService, ICoreNotebookService coreNotebookService, ToolAccessMode accessMode, Lesson lesson, LearnerProgress progress, User user) {
        super(design, activityDAO);
        this.activityListStack = new ArrayStack(5);
        this.accessMode = accessMode;
        this.lamsCoreToolService = lamsCoreToolService;
        this.coreNotebookService = coreNotebookService;
        this.user = user;
        this.lesson = lesson;
        this.progress = progress;
    }

    public boolean startComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        boolean flattenLearnerBranching;
        boolean bl = flattenLearnerBranching = (activity.isBranchingActivity() || activity.isSequenceActivity() && activity.getParentActivity().isBranchingActivity()) && this.accessMode == ToolAccessMode.LEARNER;
        if (!flattenLearnerBranching) {
            this.activityListStack.push(this.currentPortfolioList);
            this.currentPortfolioList = new ArrayList();
        }
        return true;
    }

    public void endComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        boolean flattenLearnerBranching;
        ActivityPortfolio complexPortfolio = null;
        boolean bl = flattenLearnerBranching = (activity.isBranchingActivity() || activity.isSequenceActivity() && activity.getParentActivity().isBranchingActivity()) && this.accessMode == ToolAccessMode.LEARNER;
        if (this.currentPortfolioList.size() > 0 || this.accessMode == ToolAccessMode.TEACHER) {
            complexPortfolio = this.createActivityPortfolio((Activity)activity);
            if (this.currentPortfolioList.size() > 0) {
                complexPortfolio.setChildPortfolios(this.currentPortfolioList);
            }
            if (activity.isSystemToolActivity()) {
                String exportURL = this.getExportURLForSystemTool((Activity)activity);
                complexPortfolio = complexPortfolio == null ? this.createActivityPortfolio((Activity)activity) : complexPortfolio;
                complexPortfolio.setExportUrl(exportURL);
                complexPortfolio.setHeadingNoPage(exportURL == null);
            } else {
                complexPortfolio.setHeadingNoPage(true);
            }
        }
        if (!flattenLearnerBranching) {
            this.currentPortfolioList = (ArrayList)this.activityListStack.pop();
        }
        if (complexPortfolio != null && !flattenLearnerBranching) {
            this.currentPortfolioList.add(complexPortfolio);
        }
    }

    public void startSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
    }

    public void endSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
        if (this.accessMode == ToolAccessMode.LEARNER && !this.progress.getCompletedActivities().containsKey(activity) && !this.progress.getAttemptedActivities().contains(activity)) {
            return;
        }
        String exportUrlForTool = null;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            Tool tool = toolActivity.getTool();
            exportUrlForTool = this.accessMode == ToolAccessMode.TEACHER ? tool.getExportPortfolioClassUrl() : tool.getExportPortfolioLearnerUrl();
            if (exportUrlForTool != null) {
                if (this.accessMode == ToolAccessMode.LEARNER) {
                    exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"userID", (String)this.user.getUserId().toString());
                    ToolSession toolSession = this.lamsCoreToolService.getToolSessionByActivity(this.user, toolActivity);
                    if (toolSession != null) {
                        exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"toolSessionID", (String)toolSession.getToolSessionId().toString());
                    }
                } else if (this.accessMode == ToolAccessMode.TEACHER) {
                    exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"toolContentID", (String)toolActivity.getToolContentId().toString());
                }
                exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"offline", (String)activity.getRunOffline().toString());
            }
            ActivityPortfolio p = this.createActivityPortfolio((Activity)activity);
            p.setExportUrl(exportUrlForTool);
            if (toolActivity.getCompetenceMappings() != null) {
                Set<String> competencesCovered = p.getCompetencesCovered();
                for (CompetenceMapping mapping : toolActivity.getCompetenceMappings()) {
                    competencesCovered.add(mapping.getCompetence().getTitle());
                }
            }
            this.currentPortfolioList.add(p);
        } else if (activity.isSystemToolActivity() && (exportUrlForTool = this.getExportURLForSystemTool((Activity)activity)) != null) {
            ActivityPortfolio p = this.createActivityPortfolio((Activity)activity);
            p.setExportUrl(exportUrlForTool);
            this.currentPortfolioList.add(p);
        }
    }

    private String getExportURLForSystemTool(Activity activity) {
        String exportUrlForTool = null;
        ISystemToolActivity sysToolActivity = (ISystemToolActivity)activity;
        SystemTool tool = sysToolActivity.getSystemTool();
        if (tool != null) {
            exportUrlForTool = this.accessMode == ToolAccessMode.LEARNER ? tool.getExportPortfolioLearnerUrl() : tool.getExportPortfolioClassUrl();
        }
        if (exportUrlForTool != null) {
            if (this.accessMode == ToolAccessMode.LEARNER) {
                exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"userID", (String)this.user.getUserId().toString());
                exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"toolSessionID", (String)"0");
            } else {
                exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"toolContentID", (String)"0");
            }
            exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"activityID", (String)activity.getActivityId().toString());
            exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"lessonID", (String)this.lesson.getLessonId().toString());
            exportUrlForTool = WebUtil.appendParameterToURL((String)exportUrlForTool, (String)"offline", (String)activity.getRunOffline().toString());
        }
        return exportUrlForTool;
    }

    public void processNotebook(ToolAccessMode notebookAccessMode) throws ExportPortfolioException {
        List entries = null;
        if (this.lesson == null || this.user == null) {
            throw new ExportPortfolioException();
        }
        if (notebookAccessMode == null) {
            entries = this.coreNotebookService.getEntry(this.lesson.getLessonId(), CoreNotebookConstants.SCRATCH_PAD, this.user.getUserId());
        } else if (notebookAccessMode.equals((Object)ToolAccessMode.TEACHER)) {
            entries = this.coreNotebookService.getEntry(this.lesson.getLessonId(), CoreNotebookConstants.SCRATCH_PAD, CoreNotebookConstants.JOURNAL_SIG, this.user.getUserId());
        }
        if (entries == null) {
            throw new ExportPortfolioException();
        }
        for (NotebookEntry entry : entries) {
            NotebookPortfolio portfolio = this.createNotebookPortfolio(entry);
            this.currentNotebookList.add(portfolio);
        }
    }

    protected ActivityPortfolio createActivityPortfolio(Activity activity) {
        if (activity == null) {
            String error = "Cannot create portfolio for this activity as the activity is null.";
            log.error((Object)error);
            throw new ExportPortfolioException(error);
        }
        ActivityPortfolio p = new ActivityPortfolio();
        p.setActivityId(activity.getActivityId());
        p.setActivityName(activity.getTitle());
        p.setActivityDescription(activity.getDescription());
        p.setFloating(activity.isFloatingActivity());
        return p;
    }

    protected NotebookPortfolio createNotebookPortfolio(NotebookEntry entry) {
        if (entry == null) {
            String error = "Cannot create portfolio for this notebook entry as the entry is null.";
            log.error((Object)error);
            throw new ExportPortfolioException(error);
        }
        NotebookPortfolio p = new NotebookPortfolio();
        p.setEntry(entry.getEntry());
        p.setTitle(entry.getTitle());
        p.setCreated(entry.getCreateDate());
        p.setModified(entry.getLastModified());
        if (entry.getExternalSignature().equals(CoreNotebookConstants.JOURNAL_SIG)) {
            p.setTeacherViewable(true);
        } else {
            p.setTeacherViewable(false);
        }
        return p;
    }

    public ArrayList<ActivityPortfolio> getPortfolioList() {
        return this.mainPortfolioList;
    }

    public ArrayList<NotebookPortfolio> getNotebookList() {
        return this.mainNotebookList;
    }
}

