/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.web.action;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundler {
    protected static Logger log = Logger.getLogger(Bundler.class);

    protected void createDirectories(List<String> directoriesRequired) {
        for (String directoryPath : directoriesRequired) {
            File dir = new File(directoryPath);
            if (dir.exists() || dir.mkdirs()) continue;
            log.error((Object)("Unable to create directory for export portfolio: " + directoryPath));
        }
    }

    protected void copyFile(String destFilePath, File srcFile) throws IOException {
        log.debug((Object)("Copying file " + srcFile + " to " + destFilePath));
        File destFile = new File(destFilePath);
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            String message = "Unable to write out file needed for export portfolio. File was " + srcFile;
            log.error((Object)message, (Throwable)e);
        }
    }
}

