/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.web.action;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;

public class ExportDownloadServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ExportDownloadServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String zipFilename = WebUtil.readStrParam((HttpServletRequest)request, (String)"fileLocation");
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + this.getFilename(zipFilename) + "\"");
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(this.constructAbsolutePath(zipFilename))));
        ServletOutputStream out = response.getOutputStream();
        try {
            int ch;
            int count = 0;
            while ((ch = ((InputStream)in).read()) != -1) {
                out.write((char)ch);
                ++count;
            }
            log.debug((Object)("Wrote out " + count + " bytes"));
            response.setContentLength(count);
            out.flush();
        }
        catch (IOException e) {
            log.info((Object)("Exception occured writing out file - probably just the user cancelling on their end." + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private String constructAbsolutePath(String relativePath) {
        return FileUtil.TEMP_DIR + File.separator + this.getDirname(relativePath) + File.separator + "export.zip";
    }

    private String getDirname(String path) {
        int index = path.indexOf(File.separator);
        return index > 0 ? path.substring(0, index) : path;
    }

    private String getFilename(String path) {
        int index = path.lastIndexOf(File.separator);
        return index > 0 ? path.substring(index + 1) : path;
    }
}

