/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.progress;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.ArrayStack;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesignProcessor;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressBuilder
extends LearningDesignProcessor {
    private static Logger log = Logger.getLogger(ProgressBuilder.class);
    User user;
    LearnerProgress progress;
    ActivityMapping activityMapping;
    ArrayList<ActivityURL> mainActivityList;
    ArrayStack activityListStack;
    ArrayList<ActivityURL> currentActivityList;
    String forceLearnerURL;
    boolean previewMode;
    boolean isFloating;

    public ProgressBuilder(LearnerProgress progress, IActivityDAO activityDAO, ActivityMapping activityMapping) {
        super(progress.getLesson().getLearningDesign(), activityDAO);
        this.user = progress.getUser();
        this.progress = progress;
        this.activityMapping = activityMapping;
        this.mainActivityList = new ArrayList();
        this.currentActivityList = this.mainActivityList;
        this.activityListStack = new ArrayStack(5);
        Lesson lesson = progress.getLesson();
        this.previewMode = lesson.isPreviewLesson();
        this.isFloating = false;
        this.forceLearnerURL = "learner.do?method=forceMoveRedirect&lessonID=" + progress.getLesson().getLessonId() + "&destActivityID=";
    }

    public boolean startComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        this.activityListStack.push(this.currentActivityList);
        this.currentActivityList = new ArrayList();
        if (activity.isSequenceActivity()) {
            return this.progress.getProgressState((Activity)activity) != 3;
        }
        if (activity.isFloatingActivity()) {
            this.isFloating = true;
        }
        return true;
    }

    public void endComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        if (activity.isBranchingActivity()) {
            boolean branchStarted = false;
            Iterator<ActivityURL> iter = this.currentActivityList.iterator();
            while (!branchStarted && iter.hasNext()) {
                ActivityURL sequenceURL = iter.next();
                if (sequenceURL.getStatus() == 3) continue;
                branchStarted = true;
                this.currentActivityList = (ArrayList)this.activityListStack.pop();
                this.currentActivityList.addAll(sequenceURL.getChildActivities());
            }
            if (!branchStarted) {
                this.currentActivityList = (ArrayList)this.activityListStack.pop();
                this.currentActivityList.add(this.createActivityURL((Activity)activity));
            }
        } else {
            ActivityURL complexActivityURL = this.createActivityURL((Activity)activity);
            complexActivityURL.setChildActivities(this.currentActivityList);
            this.currentActivityList = (ArrayList)this.activityListStack.pop();
            this.currentActivityList.add(complexActivityURL);
            if (activity.isFloatingActivity()) {
                this.isFloating = false;
            }
        }
    }

    public void startSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
    }

    public void endSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
        ActivityURL p = this.createActivityURL((Activity)activity);
        this.currentActivityList.add(p);
    }

    protected ActivityURL createActivityURL(Activity activity) throws LearningDesignProcessorException {
        if (activity == null) {
            String error = "Cannot create activity progress for this activity as the activity is null.";
            log.error((Object)error);
            throw new LearningDesignProcessorException(error);
        }
        ActivityURL activityURL = LearningWebUtil.getActivityURL(this.activityMapping, this.progress, activity, false, this.isFloating);
        if (activityURL.getStatus() == 3) {
            activityURL.setUrl(this.previewMode || this.isFloating ? this.forceLearnerURL + activity.getActivityId() : null);
        }
        if (activity.isFloatingActivity()) {
            activityURL.setUrl(null);
        }
        return activityURL;
    }

    public ArrayList<ActivityURL> getActivityList() {
        return this.mainActivityList;
    }
}

