/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.progress;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.progress.ProgressException;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressEngine {
    protected Logger log = Logger.getLogger(ProgressEngine.class);
    private IActivityDAO activityDAO;

    public LearnerProgress calculateProgress(User learner, Activity completedActivity, LearnerProgress learnerProgress) throws ProgressException {
        if (learnerProgress.getParallelWaiting() == 2) {
            learnerProgress.setParallelWaiting((byte)0);
        }
        return this.doCalculateProgress(learner, completedActivity, learnerProgress, new LinkedList<Long>());
    }

    private LearnerProgress doCalculateProgress(User learner, Activity completedActivity, LearnerProgress learnerProgress, List<Long> completedActivityList) throws ProgressException {
        learnerProgress.setProgressState(completedActivity, (byte)1, this.activityDAO);
        completedActivityList.add(completedActivity.getActivityId());
        if (completedActivity.isStopAfterActivity().booleanValue()) {
            learnerProgress.setProgressState(completedActivity, (byte)1, this.activityDAO);
            for (Activity parentActivity = completedActivity.getParentActivity(); parentActivity != null; parentActivity = parentActivity.getParentActivity()) {
                learnerProgress.setProgressState(parentActivity, (byte)1, this.activityDAO);
                completedActivityList.add(parentActivity.getActivityId());
            }
            this.populateCurrentCompletedActivityList(learnerProgress, completedActivityList);
            return this.setLessonComplete(learnerProgress, (byte)2);
        }
        if (completedActivity.isFloating() && !completedActivity.getParentActivity().isParallelActivity()) {
            return learnerProgress;
        }
        Transition transition = completedActivity.getTransitionFrom();
        if (transition != null) {
            return this.progressCompletedActivity(learner, completedActivity, learnerProgress, transition, completedActivityList);
        }
        return this.progressParentActivity(learner, completedActivity, learnerProgress, completedActivityList);
    }

    public LearnerProgress setUpStartPoint(LearnerProgress progress) throws ProgressException {
        LearningDesign ld = progress.getLesson().getLearningDesign();
        if (progress.getLesson().getLockedForEdit().booleanValue()) {
            return this.clearProgressNowhereToGoNotCompleted(progress, "setUpStartPoint");
        }
        if (progress.isComplete()) {
            return progress;
        }
        if (ld.getFirstActivity() == null) {
            throw new ProgressException("Could not find first activity for learning design [" + ld.getTitle() + "], id[" + ld.getLearningDesignId() + "]");
        }
        if (progress.getCompletedActivities().containsKey(ld.getFirstActivity())) {
            return this.doCalculateProgress(progress.getUser(), ld.getFirstActivity(), progress, new LinkedList<Long>());
        }
        if (this.canDoActivity(progress.getLesson(), ld.getFirstActivity())) {
            progress.setCurrentActivity(ld.getFirstActivity());
            progress.setNextActivity(ld.getFirstActivity());
            this.setActivityAttempted(progress, ld.getFirstActivity());
            return progress;
        }
        return this.clearProgressNowhereToGoNotCompleted(progress, "setUpStartPoint");
    }

    private boolean canDoActivity(Lesson lesson, Activity activity) {
        LearningDesign design = lesson.getLearningDesign();
        return lesson.getLockedForEdit() == false && (design.getEditOverrideLock() == false || activity.isActivityReadOnly());
    }

    private LearnerProgress clearProgressNowhereToGoNotCompleted(LearnerProgress progress, String callingMethod) {
        if (callingMethod != null) {
            this.log.warn((Object)("Learner " + progress.getUser().getFullName() + "(" + progress.getUser().getUserId() + ") has a problem with the progress for lesson " + progress.getLesson().getLessonName() + "(" + progress.getLesson().getLessonId() + "). Completed activities so far was " + progress.getCurrentCompletedActivitiesList() + ". Setting current and next activity to null. Problem detected in method " + callingMethod + "."));
        }
        progress.setCurrentActivity(null);
        progress.setNextActivity(null);
        progress.setLessonComplete(Byte.valueOf((byte)0));
        return progress;
    }

    public void setActivityAttempted(LearnerProgress progress, Activity activity) {
        progress.setProgressState(activity, (byte)2, this.activityDAO);
        activity.setReadOnly(Boolean.valueOf(true));
        if (activity.isParallelActivity()) {
            ParallelActivity parallel = (ParallelActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId(), ParallelActivity.class);
            for (Activity element : parallel.getActivities()) {
                this.setActivityAttempted(progress, element);
            }
        }
        this.activityDAO.insertOrUpdate((Object)activity);
    }

    private LearnerProgress progressCompletedActivity(User learner, Activity completedActivity, LearnerProgress learnerProgress, Transition transition, List<Long> completedActivityList) throws ProgressException {
        Activity nextActivity = transition.getToActivity();
        if (!learnerProgress.getCompletedActivities().containsKey(nextActivity)) {
            learnerProgress.setPreviousActivity(completedActivity);
            this.populateCurrentCompletedActivityList(learnerProgress, completedActivityList);
            if (this.canDoActivity(learnerProgress.getLesson(), nextActivity)) {
                learnerProgress.setCurrentActivity(nextActivity);
                learnerProgress.setNextActivity(nextActivity);
                this.setActivityAttempted(learnerProgress, nextActivity);
                if (learnerProgress.getParallelWaiting() == 1) {
                    learnerProgress.setParallelWaiting((byte)2);
                }
            } else {
                return this.clearProgressNowhereToGoNotCompleted(learnerProgress, "progressCompletedActivity");
            }
            return learnerProgress;
        }
        return this.doCalculateProgress(learner, nextActivity, learnerProgress, completedActivityList);
    }

    private LearnerProgress progressParentActivity(User learner, Activity completedActivity, LearnerProgress learnerProgress, List<Long> completedActivityList) throws ProgressException {
        Activity parent = completedActivity.getParentActivity();
        if (parent != null) {
            if (!parent.isComplexActivity()) {
                throw new ProgressException("Parent activity is always expected to the complex activity. But activity type" + parent.getActivityTypeId() + " has been found");
            }
            ComplexActivity complexParent = (ComplexActivity)this.activityDAO.getActivityByActivityId(parent.getActivityId(), ComplexActivity.class);
            if (!learnerProgress.getCompletedActivities().containsKey(complexParent) && !complexParent.areChildrenCompleted(learnerProgress)) {
                Activity nextActivity = complexParent.getNextActivityByParent(completedActivity);
                if (!this.isNextActivityValid(nextActivity)) {
                    this.log.error((Object)("Error occurred in progress engine. Unexpected Null activity received when progressing to the next activity within a incomplete parent activity: Parent activity id [" + parent.getActivityId() + "]"));
                    learnerProgress = this.clearProgressNowhereToGoNotCompleted(learnerProgress, null);
                } else if (this.isParallelWaitActivity(nextActivity)) {
                    learnerProgress.setParallelWaiting((byte)1);
                    this.populateCurrentCompletedActivityList(learnerProgress, completedActivityList);
                } else if (this.canDoActivity(learnerProgress.getLesson(), nextActivity)) {
                    learnerProgress.setNextActivity(nextActivity);
                    this.setActivityAttempted(learnerProgress, nextActivity);
                    this.populateCurrentCompletedActivityList(learnerProgress, completedActivityList);
                } else {
                    learnerProgress = this.clearProgressNowhereToGoNotCompleted(learnerProgress, "progressParentActivity");
                }
            } else {
                learnerProgress.setPreviousActivity((Activity)complexParent);
                this.doCalculateProgress(learner, parent, learnerProgress, completedActivityList);
                if (learnerProgress.getParallelWaiting() == 1) {
                    learnerProgress.setParallelWaiting((byte)2);
                }
            }
        } else {
            learnerProgress = this.setLessonComplete(learnerProgress, (byte)1);
        }
        return learnerProgress;
    }

    private LearnerProgress setLessonComplete(LearnerProgress learnerProgress, byte completionStatus) {
        learnerProgress.setCurrentActivity(null);
        learnerProgress.setNextActivity(null);
        learnerProgress.setLessonComplete(Byte.valueOf(completionStatus));
        return learnerProgress;
    }

    private void populateCurrentCompletedActivityList(LearnerProgress learnerProgress, List<Long> completedActivityList) {
        learnerProgress.setCurrentCompletedActivitiesList(completedActivityList);
        completedActivityList.clear();
    }

    private boolean isNextActivityValid(Activity nextActivity) {
        return !nextActivity.isNull() || this.isParallelWaitActivity(nextActivity);
    }

    private boolean isParallelWaitActivity(Activity nextActivity) {
        return nextActivity.getActivityTypeId() != null && nextActivity.getActivityTypeId() == -1;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }
}

