/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.progress.ProgressBuilder;
import org.lamsfoundation.lams.learning.progress.ProgressEngine;
import org.lamsfoundation.lams.learning.progress.ProgressException;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceException;
import org.lamsfoundation.lams.learning.web.bean.GateActivityDTO;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ConditionGateActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouper;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.ToolBranchingActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.dao.DeadlockLoserDataAccessException;

public class LearnerService
implements ICoreLearnerService {
    private static Logger log = Logger.getLogger(LearnerService.class);
    private ILearnerProgressDAO learnerProgressDAO;
    private ILessonDAO lessonDAO;
    private IActivityDAO activityDAO;
    private IGroupingDAO groupingDAO;
    private ProgressEngine progressEngine;
    private IToolSessionDAO toolSessionDAO;
    private ILamsCoreToolService lamsCoreToolService;
    private ActivityMapping activityMapping;
    private IUserManagementService userManagementService;
    private ILessonService lessonService;
    private static HashMap<Integer, Long> syncMap = new HashMap();
    protected MessageService messageService;

    public LearnerService(ProgressEngine progressEngine) {
        this.progressEngine = progressEngine;
    }

    public LearnerService() {
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLearnerProgressDAO(ILearnerProgressDAO learnerProgressDAO) {
        this.learnerProgressDAO = learnerProgressDAO;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsToolService) {
        this.lamsCoreToolService = lamsToolService;
    }

    public void setActivityMapping(ActivityMapping activityMapping) {
        this.activityMapping = activityMapping;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userService) {
        this.userManagementService = userService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public LessonDTO[] getActiveLessonsFor(Integer learnerId) {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        List activeLessons = this.lessonDAO.getActiveLessonsForLearner(learner);
        return this.getLessonDataFor(activeLessons);
    }

    public Lesson getLesson(Long lessonId) {
        return this.lessonDAO.getLesson(lessonId);
    }

    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.getLesson(lessonId);
        return lesson != null ? lesson.getLessonData() : null;
    }

    public LearnerProgress joinLesson(Integer learnerId, Long lessonID) {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        Lesson lesson = this.getLesson(lessonID);
        if (lesson == null || !lesson.isLessonStarted()) {
            log.error((Object)("joinLesson: Learner " + learner.getLogin() + " joining lesson " + lesson + " but lesson has not started"));
            throw new LearnerServiceException("Cannot join lesson as lesson has not started");
        }
        LearnerProgress learnerProgress = this.learnerProgressDAO.getLearnerProgressByLearner(learner.getUserId(), lessonID);
        if (learnerProgress == null) {
            learnerProgress = new LearnerProgress(learner, lesson);
            try {
                this.progressEngine.setUpStartPoint(learnerProgress);
            }
            catch (ProgressException e) {
                log.error((Object)("error occurred in 'setUpStartPoint':" + e.getMessage()));
                throw new LearnerServiceException(e.getMessage());
            }
            learnerProgress.setStartDate((Date)new Timestamp(new Date().getTime()));
            try {
                this.learnerProgressDAO.saveLearnerProgress(learnerProgress);
            }
            catch (DeadlockLoserDataAccessException e) {
                log.error((Object)"Deadlock occurred when attempting to joing the lesson. Retrying...", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)"While retrying to join lesson, thread was interrupted.", (Throwable)e);
                }
                this.learnerProgressDAO.saveLearnerProgress(learnerProgress);
            }
        } else {
            Activity currentActivity = learnerProgress.getCurrentActivity();
            if (currentActivity == null) {
                try {
                    this.progressEngine.setUpStartPoint(learnerProgress);
                }
                catch (ProgressException e) {
                    log.error((Object)("error occurred in 'setUpStartPoint':" + e.getMessage()));
                    throw new LearnerServiceException(e.getMessage());
                }
            }
            if (!learnerProgress.isRestarting()) {
                learnerProgress.setRestarting(true);
                this.learnerProgressDAO.updateLearnerProgress(learnerProgress);
            }
        }
        return learnerProgress;
    }

    public void createToolSessionsIfNecessary(Activity activity, LearnerProgress learnerProgress) {
        try {
            if (activity != null && activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)activity;
                this.createToolSessionFor(toolActivity, learnerProgress.getUser(), learnerProgress.getLesson());
            }
        }
        catch (LamsToolServiceException e) {
            log.error((Object)("error occurred in 'createToolSessionFor':" + e.getMessage()));
            throw new LearnerServiceException(e.getMessage());
        }
        catch (ToolException e) {
            log.error((Object)("error occurred in 'createToolSessionFor':" + e.getMessage()));
            throw new LearnerServiceException(e.getMessage());
        }
    }

    public LearnerProgress getProgress(Integer learnerId, Long lessonId) {
        return this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
    }

    public LearnerProgress getProgressById(Long progressId) {
        return this.learnerProgressDAO.getLearnerProgress(progressId);
    }

    public LearnerProgressDTO getProgressDTOByLessonId(Long lessonId, Integer learnerId) {
        return this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId).getLearnerProgressData();
    }

    public Object[] getStructuredActivityURLs(Integer learnerId, Long lessonId) {
        LearnerProgress progress = this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
        Lesson lesson = progress.getLesson();
        ProgressBuilder builder = new ProgressBuilder(progress, this.activityDAO, this.activityMapping);
        builder.parseLearningDesign();
        Object[] retValue = new Object[]{builder.getActivityList(), progress.getCurrentActivity() != null ? progress.getCurrentActivity().getActivityId() : null};
        return retValue;
    }

    public LearnerProgress chooseActivity(Integer learnerId, Long lessonId, Activity activity, Boolean clearCompletedFlag) {
        LearnerProgress progress = this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
        if (!progress.getCompletedActivities().containsKey(activity)) {
            if (clearCompletedFlag.booleanValue() && activity.getParentActivity() != null && activity.getParentActivity().isSequenceActivity() && progress.isComplete()) {
                progress.setLessonComplete(Byte.valueOf((byte)0));
            }
            this.progressEngine.setActivityAttempted(progress, activity);
            progress.setCurrentActivity(activity);
            progress.setNextActivity(activity);
            this.learnerProgressDAO.saveLearnerProgress(progress);
        }
        return progress;
    }

    public LearnerProgress moveToActivity(Integer learnerId, Long lessonId, Activity fromActivity, Activity toActivity) throws LearnerServiceException {
        int count = 0;
        LearnerProgress progress = null;
        while (syncMap.containsKey(learnerId)) {
            ++count;
            try {
                Thread.sleep(1000L);
                if (count <= 100) continue;
                throw new LearnerServiceException("Thread wait count exceeded limit.");
            }
            catch (InterruptedException e1) {
                throw new LearnerServiceException("While retrying to move activity, thread was interrupted.", e1);
            }
        }
        try {
            syncMap.put(learnerId, lessonId);
            progress = this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
            if (fromActivity != null && fromActivity.getActivityId() != progress.getCurrentActivity().getActivityId()) {
                progress.setProgressState(fromActivity, (byte)2, this.activityDAO);
            }
            if (toActivity != null) {
                progress.setProgressState(toActivity, (byte)2, this.activityDAO);
                if (!toActivity.getReadOnly().booleanValue()) {
                    toActivity.setReadOnly(Boolean.valueOf(true));
                    this.activityDAO.update((Object)toActivity);
                }
                if (!toActivity.isFloating()) {
                    progress.setCurrentActivity(toActivity);
                    progress.setNextActivity(toActivity);
                }
            }
            this.learnerProgressDAO.updateLearnerProgress(progress);
        }
        catch (Exception e) {
            throw new LearnerServiceException(e.getMessage());
        }
        finally {
            if (syncMap.containsKey(learnerId)) {
                syncMap.remove(learnerId);
            }
        }
        return progress;
    }

    public LearnerProgress calculateProgress(Activity completedActivity, Integer learnerId, LearnerProgress currentLearnerProgress) {
        try {
            LearnerProgress learnerProgress = this.progressEngine.calculateProgress(currentLearnerProgress.getUser(), completedActivity, currentLearnerProgress);
            this.learnerProgressDAO.updateLearnerProgress(learnerProgress);
            return learnerProgress;
        }
        catch (ProgressException e) {
            throw new LearnerServiceException(e.getMessage());
        }
    }

    public String completeToolSession(Long toolSessionId, Long learnerId) {
        String returnURL = null;
        ToolSession toolSession = this.lamsCoreToolService.getToolSessionById(toolSessionId);
        if (toolSession == null) {
            returnURL = this.activityMapping.getProgressBrokenURL();
        } else {
            Long lessonId = toolSession.getLesson().getLessonId();
            LearnerProgress currentProgress = this.getProgress(new Integer(learnerId.intValue()), lessonId);
            returnURL = this.activityMapping.getCompleteActivityURL(toolSession.getToolActivity().getActivityId(), currentProgress.getLearnerProgressId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CompleteToolSession() for tool session id " + toolSessionId + " learnerId " + learnerId + " url is " + returnURL));
        }
        return returnURL;
    }

    public LearnerProgress completeActivity(Integer learnerId, Activity activity, LearnerProgress progress) {
        LearnerProgress nextLearnerProgress = null;
        if (activity == null) {
            try {
                nextLearnerProgress = this.progressEngine.setUpStartPoint(progress);
            }
            catch (ProgressException e) {
                log.error((Object)("error occurred in 'setUpStartPoint':" + e.getMessage()), (Throwable)e);
                throw new LearnerServiceException(e);
            }
        } else {
            nextLearnerProgress = this.calculateProgress(activity, learnerId, progress);
        }
        return nextLearnerProgress;
    }

    public LearnerProgress completeActivity(Integer learnerId, Activity activity, Long lessonId) {
        LearnerProgress currentProgress = this.getProgress(new Integer(learnerId), lessonId);
        return this.completeActivity(learnerId, activity, currentProgress);
    }

    public void exitLesson(Integer learnerId, Long lessonId) {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        LearnerProgress progress = this.learnerProgressDAO.getLearnerProgressByLearner(learner.getUserId(), lessonId);
        if (progress == null) {
            String error = "Learner Progress " + lessonId + " does not exist. Cannot exit lesson successfully.";
            log.error((Object)error);
            throw new LearnerServiceException(error);
        }
        progress.setRestarting(true);
        this.learnerProgressDAO.updateLearnerProgress(progress);
    }

    public Activity getActivity(Long activityId) {
        return this.activityDAO.getActivityByActivityId(activityId);
    }

    public boolean performGrouping(Long lessonId, Long groupingActivityId, Integer learnerId, boolean forceGrouping) throws LearnerServiceException {
        boolean groupingDone;
        block7: {
            GroupingActivity groupingActivity = (GroupingActivity)this.activityDAO.getActivityByActivityId(groupingActivityId, GroupingActivity.class);
            User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
            groupingDone = false;
            try {
                if (groupingActivity != null && groupingActivity.getCreateGrouping() != null && learner != null) {
                    Grouping grouping = groupingActivity.getCreateGrouping();
                    groupingDone = grouping.doesLearnerExist(learner);
                    if (!groupingDone) {
                        if (grouping.isRandomGrouping()) {
                            this.lessonService.performGrouping(lessonId, groupingActivity, learner);
                            groupingDone = true;
                        } else if (forceGrouping) {
                            Lesson lesson = this.getLesson(lessonId);
                            groupingDone = this.forceGrouping(lesson, grouping, null, learner);
                        }
                    }
                    break block7;
                }
                String error = "Grouping activity " + groupingActivity + " learner " + learnerId + " does not exist. Cannot perform grouping.";
                log.error((Object)error);
                throw new LearnerServiceException(error);
            }
            catch (LessonServiceException e) {
                throw new LearnerServiceException("performGrouping failed due to " + e.getMessage(), e);
            }
        }
        return groupingDone;
    }

    public boolean learnerChooseGroup(Long lessonId, Long groupingActivityId, Long groupId, Integer learnerId) throws LearnerServiceException {
        Grouping grouping;
        GroupingActivity groupingActivity = (GroupingActivity)this.activityDAO.getActivityByActivityId(groupingActivityId, GroupingActivity.class);
        if (groupingActivity != null && groupId != null && learnerId != null && (grouping = this.groupingDAO.getGroupingById(groupingActivity.getCreateGrouping().getGroupingId())) != null && grouping.isLearnerChoiceGrouping()) {
            User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
            if (grouping.doesLearnerExist(learner)) {
                return true;
            }
            if (learner != null) {
                Integer maxNumberOfLearnersPerGroup = null;
                Set groups = grouping.getGroups();
                if (((LearnerChoiceGrouping)grouping).getLearnersPerGroup() == null) {
                    if (((LearnerChoiceGrouping)grouping).getEqualNumberOfLearnersPerGroup().booleanValue() && ((LearnerChoiceGrouping)grouping).getLearnersPerGroup() == null) {
                        Lesson lesson = this.getLesson(lessonId);
                        int learnerCount = lesson.getAllLearners().size();
                        int groupCount = grouping.getGroups().size();
                        maxNumberOfLearnersPerGroup = learnerCount / groupCount + (learnerCount % groupCount == 0 ? 0 : 1);
                    }
                } else {
                    maxNumberOfLearnersPerGroup = ((LearnerChoiceGrouping)grouping).getLearnersPerGroup();
                }
                if (maxNumberOfLearnersPerGroup != null) {
                    for (Group group : groups) {
                        if (!group.getGroupId().equals(groupId) || group.getUsers().size() < maxNumberOfLearnersPerGroup) continue;
                        return false;
                    }
                }
                this.lessonService.performGrouping(grouping, groupId, learner);
                return true;
            }
        }
        return false;
    }

    private boolean forceGrouping(Lesson lesson, Grouping grouping, Group group, User learner) {
        boolean groupingDone = false;
        if (lesson.isPreviewLesson()) {
            ArrayList<User> learnerList = new ArrayList<User>();
            learnerList.add(learner);
            if (group != null) {
                if (group.getGroupId() != null) {
                    this.lessonService.performGrouping(grouping, group.getGroupId(), learnerList);
                } else {
                    this.lessonService.performGrouping(grouping, group.getGroupName(), learnerList);
                }
            } else if (grouping.getGroups().size() > 0) {
                Group aGroup = (Group)grouping.getGroups().iterator().next();
                if (aGroup.getGroupId() != null) {
                    this.lessonService.performGrouping(grouping, aGroup.getGroupId(), learnerList);
                } else {
                    this.lessonService.performGrouping(grouping, aGroup.getGroupName(), learnerList);
                }
            } else {
                this.lessonService.performGrouping(grouping, (String)null, learnerList);
            }
            groupingDone = true;
        }
        return groupingDone;
    }

    public GateActivityDTO knockGate(Long gateActivityId, User knocker, boolean forceGate) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateActivityId, GateActivity.class);
        if (gate != null) {
            return this.knockGate(gate, knocker, forceGate);
        }
        String error = "Gate activity " + gateActivityId + " does not exist. Cannot knock on gate.";
        log.error((Object)error);
        throw new LearnerServiceException(error);
    }

    public GateActivityDTO knockGate(GateActivity gate, User knocker, boolean forceGate) {
        Lesson lesson = this.getLessonByActivity((Activity)gate);
        List lessonLearners = this.getLearnersForGate(gate, lesson);
        boolean gateOpen = false;
        if (forceGate && lesson.isPreviewLesson()) {
            gateOpen = gate.forceGateOpen();
        }
        if (!gateOpen && !(gateOpen = gate.shouldOpenGateFor(knocker, lessonLearners))) {
            gateOpen = this.determineConditionGateStatus(gate, knocker);
        }
        this.activityDAO.update((Object)gate);
        return new GateActivityDTO(gate, lessonLearners, gateOpen);
    }

    private List getLearnersForGate(GateActivity gate, Lesson lesson) {
        Activity branchActivity;
        List lessonLearners = null;
        for (branchActivity = gate.getParentBranch(); branchActivity != null && !branchActivity.getParentActivity().isChosenBranchingActivity() && !branchActivity.getParentActivity().isGroupBranchingActivity(); branchActivity = branchActivity.getParentBranch()) {
        }
        if (branchActivity != null) {
            SequenceActivity branchSequence = (SequenceActivity)this.activityDAO.getActivityByActivityId(branchActivity.getActivityId(), SequenceActivity.class);
            Set branchEntries = branchSequence.getBranchEntries();
            for (BranchActivityEntry branchActivityEntry : branchEntries) {
                Group group = branchActivityEntry.getGroup();
                if (group == null) continue;
                List groupLearners = this.lessonService.getActiveLessonLearnersByGroup(lesson.getLessonId(), group.getGroupId());
                if (lessonLearners == null) {
                    lessonLearners = groupLearners;
                    continue;
                }
                lessonLearners.addAll(groupLearners);
            }
        } else {
            lessonLearners = this.getActiveLearnersByLesson(lesson.getLessonId());
        }
        return lessonLearners;
    }

    public List getLearnersForGate(GateActivity gate) {
        return this.getLearnersForGate(gate, this.getLessonByActivity((Activity)gate));
    }

    public String getLearnerActivityURL(Integer learnerId, Long activityId) {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        Activity requestedActivity = this.getActivity(activityId);
        Lesson lesson = this.getLessonByActivity(requestedActivity);
        return this.activityMapping.calculateActivityURLForProgressView(lesson, learner, requestedActivity);
    }

    public List getActiveLearnersByLesson(long lessonId) {
        return this.lessonService.getActiveLessonLearners(Long.valueOf(lessonId));
    }

    public Integer getCountActiveLearnersByLesson(long lessonId) {
        return this.lessonService.getCountActiveLessonLearners(Long.valueOf(lessonId));
    }

    public Lesson getLessonByActivity(Activity activity) {
        Lesson lesson = this.lessonDAO.getLessonForActivity(activity.getActivityId().longValue());
        if (lesson == null) {
            log.warn((Object)("Tried to get lesson id for a non-lesson based activity. An error is likely to be thrown soon. Activity was " + activity));
        }
        return lesson;
    }

    private void createToolSessionFor(ToolActivity toolActivity, User learner, Lesson lesson) throws LamsToolServiceException, ToolException {
        ToolSession toolSession = this.lamsCoreToolService.createToolSession(learner, toolActivity, lesson);
        if (toolSession != null) {
            toolActivity.getToolSessions().add(toolSession);
            this.lamsCoreToolService.notifyToolsToCreateSession(toolSession, toolActivity);
        }
    }

    private LessonDTO[] getLessonDataFor(List lessons) {
        ArrayList<LessonDTO> lessonDTOList = new ArrayList<LessonDTO>();
        for (Lesson currentLesson : lessons) {
            lessonDTOList.add(currentLesson.getLessonData());
        }
        return lessonDTOList.toArray(new LessonDTO[lessonDTOList.size()]);
    }

    public SequenceActivity determineBranch(Lesson lesson, BranchingActivity branchingActivity, Integer learnerId) throws LearnerServiceException {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        if (learner == null) {
            String error = "determineBranch: learner " + learnerId + " does not exist. Cannot determine branch.";
            log.error((Object)error);
            throw new LearnerServiceException(error);
        }
        try {
            if (branchingActivity.isToolBranchingActivity()) {
                return this.determineToolBasedBranch(lesson, (ToolBranchingActivity)branchingActivity, learner);
            }
            return this.determineGroupBasedBranch(lesson, branchingActivity, learner);
        }
        catch (LessonServiceException e) {
            String message = "determineBranch failed due to " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw new LearnerServiceException("determineBranch failed due to " + e.getMessage(), e);
        }
    }

    private SequenceActivity determineToolBasedBranch(Lesson lesson, ToolBranchingActivity branchingActivity, User learner) {
        Activity defaultBranch = branchingActivity.getDefaultActivity();
        SequenceActivity matchedBranch = null;
        ToolSession toolSession = null;
        for (Activity inputActivity : branchingActivity.getInputActivities()) {
            toolSession = this.lamsCoreToolService.getToolSessionByLearner(learner, inputActivity);
        }
        if (toolSession != null) {
            TreeMap<BranchCondition, SequenceActivity> conditionsMap = new TreeMap<BranchCondition, SequenceActivity>();
            for (Activity branchActivity : branchingActivity.getActivities()) {
                SequenceActivity branchSequence = (SequenceActivity)this.activityDAO.getActivityByActivityId(branchActivity.getActivityId(), SequenceActivity.class);
                for (BranchActivityEntry entry : branchSequence.getBranchEntries()) {
                    if (entry.getCondition() == null) continue;
                    conditionsMap.put(entry.getCondition(), branchSequence);
                }
            }
            HashMap<String, ToolOutput> toolOutputMap = new HashMap<String, ToolOutput>();
            Iterator conditionIterator = conditionsMap.keySet().iterator();
            while (matchedBranch == null && conditionIterator.hasNext()) {
                BranchCondition condition = (BranchCondition)conditionIterator.next();
                String conditionName = condition.getName();
                ToolOutput toolOutput = (ToolOutput)toolOutputMap.get(conditionName);
                if (toolOutput == null) {
                    toolOutput = this.lamsCoreToolService.getOutputFromTool(conditionName, toolSession, learner.getUserId());
                    if (toolOutput == null) {
                        log.warn((Object)("Condition " + condition + " refers to a tool output " + conditionName + " but tool doesn't return any tool output for that name. Skipping this condition."));
                    } else {
                        toolOutputMap.put(conditionName, toolOutput);
                    }
                }
                if (toolOutput == null || !condition.isMet(toolOutput)) continue;
                matchedBranch = (SequenceActivity)conditionsMap.get(condition);
            }
        }
        if (matchedBranch != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found branch " + matchedBranch.getActivityId() + ":" + matchedBranch.getTitle() + " for branching activity " + branchingActivity.getActivityId() + ":" + branchingActivity.getTitle() + " for learner " + learner.getUserId() + ":" + learner.getLogin()));
            }
            return matchedBranch;
        }
        if (defaultBranch != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default branch " + defaultBranch.getActivityId() + ":" + defaultBranch.getTitle() + " for branching activity " + branchingActivity.getActivityId() + ":" + branchingActivity.getTitle() + " for learner " + learner.getUserId() + ":" + learner.getLogin()));
            }
            return (SequenceActivity)this.activityDAO.getActivityByActivityId(defaultBranch.getActivityId(), SequenceActivity.class);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No branches match and no default branch exists. Uable to allocate learner to a branch for the branching activity" + branchingActivity.getActivityId() + ":" + branchingActivity.getTitle() + " for learner " + learner.getUserId() + ":" + learner.getLogin()));
        }
        return null;
    }

    private SequenceActivity determineGroupBasedBranch(Lesson lesson, BranchingActivity branchingActivity, User learner) {
        SequenceActivity sequenceActivity = null;
        if (branchingActivity.getGrouping() != null) {
            Grouping grouping = branchingActivity.getGrouping();
            Group group = grouping.getGroupBy(learner);
            if (group != null && group.getBranchActivities() != null) {
                Iterator branchesIterator = group.getBranchActivities().iterator();
                while (sequenceActivity == null && branchesIterator.hasNext()) {
                    BranchActivityEntry branchActivityEntry = (BranchActivityEntry)branchesIterator.next();
                    if (!branchActivityEntry.getBranchingActivity().equals((Object)branchingActivity)) continue;
                    sequenceActivity = branchActivityEntry.getBranchSequenceActivity();
                }
            }
            if (sequenceActivity != null && log.isDebugEnabled()) {
                log.debug((Object)("Found branch " + sequenceActivity.getActivityId() + ":" + sequenceActivity.getTitle() + " for branching activity " + branchingActivity.getActivityId() + ":" + branchingActivity.getTitle() + " for learner " + learner.getUserId() + ":" + learner.getLogin()));
            }
        }
        return sequenceActivity;
    }

    private boolean determineConditionGateStatus(GateActivity gate, User learner) {
        boolean shouldOpenGate = false;
        if (gate instanceof ConditionGateActivity) {
            ConditionGateActivity conditionGate = (ConditionGateActivity)gate;
            ToolSession toolSession = null;
            for (Activity inputActivity : conditionGate.getInputActivities()) {
                toolSession = this.lamsCoreToolService.getToolSessionByLearner(learner, inputActivity);
            }
            if (toolSession != null) {
                Set branchEntries = conditionGate.getBranchActivityEntries();
                HashMap<String, ToolOutput> toolOutputMap = new HashMap<String, ToolOutput>();
                for (BranchActivityEntry entry : branchEntries) {
                    BranchCondition condition = entry.getCondition();
                    String conditionName = condition.getName();
                    ToolOutput toolOutput = (ToolOutput)toolOutputMap.get(conditionName);
                    if (toolOutput == null) {
                        toolOutput = this.lamsCoreToolService.getOutputFromTool(conditionName, toolSession, learner.getUserId());
                        if (toolOutput == null) {
                            log.warn((Object)("Condition " + condition + " refers to a tool output " + conditionName + " but tool doesn't return any tool output for that name. Skipping this condition."));
                        } else {
                            toolOutputMap.put(conditionName, toolOutput);
                        }
                    }
                    if (toolOutput == null || !condition.isMet(toolOutput)) continue;
                    shouldOpenGate = entry.getGateOpenWhenConditionMet();
                    if (!shouldOpenGate) break;
                    conditionGate.addLeaner(learner, true);
                    break;
                }
            }
        }
        return shouldOpenGate;
    }

    public SequenceActivity selectBranch(Lesson lesson, BranchingActivity branchingActivity, Integer learnerId, Long branchId) throws LearnerServiceException {
        User learner = (User)this.userManagementService.findById(User.class, (Serializable)learnerId);
        if (learner == null) {
            String error = "selectBranch: learner " + learnerId + " does not exist. Cannot determine branch.";
            log.error((Object)error);
            throw new LearnerServiceException(error);
        }
        SequenceActivity selectedBranch = (SequenceActivity)this.activityDAO.getActivityByActivityId(branchId, SequenceActivity.class);
        if (selectedBranch != null) {
            if (selectedBranch.getParentActivity() == null || !selectedBranch.getParentActivity().equals((Object)branchingActivity)) {
                String error = "selectBranch: activity " + selectedBranch + " is not a branch within the branching activity " + branchingActivity + ". Unable to branch.";
                log.error((Object)error);
                throw new LearnerServiceException(error);
            }
            SortedSet groups = selectedBranch.getGroupsForBranch();
            Grouping grouping = branchingActivity.getGrouping();
            if (groups != null && groups.size() > 0) {
                boolean isInGroup = false;
                Group aGroup = null;
                Iterator groupIter = groups.iterator();
                while (!isInGroup && groupIter.hasNext()) {
                    aGroup = (Group)groupIter.next();
                    isInGroup = aGroup.hasLearner(learner);
                }
                if (!isInGroup && !this.forceGrouping(lesson, grouping, aGroup, learner)) {
                    String error = "selectBranch: learner " + learnerId + " cannot be added to the group " + aGroup + " for the branch " + selectedBranch + " for the lesson " + lesson.getLessonName() + " preview is " + lesson.isPreviewLesson() + ". This will only work if preview is true.";
                    log.error((Object)error);
                    throw new LearnerServiceException(error);
                }
            } else {
                if (grouping.isChosenGrouping() && grouping.getMaxNumberOfGroups() != null) {
                    grouping.setMaxNumberOfGroups(null);
                }
                Group group = this.lessonService.createGroup(grouping, selectedBranch.getTitle());
                group.allocateBranchToGroup(null, selectedBranch, branchingActivity);
                if (!this.forceGrouping(lesson, grouping, group, learner)) {
                    String error = "selectBranch: learner " + learnerId + " cannot be added to the group " + group + " for the branch " + selectedBranch + " for the lesson " + lesson.getLessonName() + " preview is " + lesson.isPreviewLesson() + ". This will only work if preview is true.";
                    log.error((Object)error);
                    throw new LearnerServiceException(error);
                }
            }
            this.groupingDAO.update((Object)grouping);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found branch " + selectedBranch.getActivityId() + ":" + selectedBranch.getTitle() + " for branching activity " + branchingActivity.getActivityId() + ":" + branchingActivity.getTitle() + " for learner " + learner.getUserId() + ":" + learner.getLogin()));
            }
            return selectedBranch;
        }
        String error = "selectBranch: Unable to find branch for branch id " + branchId;
        log.error((Object)error);
        throw new LearnerServiceException(error);
    }

    public ProgressEngine getProgressEngine() {
        return this.progressEngine;
    }

    public void setProgressEngine(ProgressEngine progressEngine) {
        this.progressEngine = progressEngine;
    }

    public Integer calculateMaxNumberOfLearnersPerGroup(Long lessonId, Long groupingId) {
        Lesson lesson = this.getLesson(lessonId);
        LearnerChoiceGrouping grouping = (LearnerChoiceGrouping)this.groupingDAO.getGroupingById(groupingId);
        Integer maxNumberOfLearnersPerGroup = null;
        int learnerCount = lesson.getAllLearners().size();
        int groupCount = grouping.getGroups().size();
        if (grouping.getLearnersPerGroup() == null) {
            if (groupCount == 0) {
                ((LearnerChoiceGrouper)grouping.getGrouper()).createGroups(grouping, 2);
                groupCount = grouping.getGroups().size();
                this.groupingDAO.update((Object)grouping);
            }
            if (grouping.getEqualNumberOfLearnersPerGroup().booleanValue()) {
                maxNumberOfLearnersPerGroup = learnerCount / groupCount + (learnerCount % groupCount == 0 ? 0 : 1);
            }
        } else {
            maxNumberOfLearnersPerGroup = grouping.getLearnersPerGroup();
            int desiredGroupCount = learnerCount / maxNumberOfLearnersPerGroup + (learnerCount % maxNumberOfLearnersPerGroup == 0 ? 0 : 1);
            if (desiredGroupCount > groupCount) {
                ((LearnerChoiceGrouper)grouping.getGrouper()).createGroups(grouping, desiredGroupCount - groupCount);
                this.groupingDAO.update((Object)grouping);
            }
        }
        return maxNumberOfLearnersPerGroup;
    }
}

