/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.web.action.ActivityAction;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.form.OptionsActivityForm;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;

public class DisplayOptionsActivityAction
extends ActivityAction {
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OptionsActivityForm form = (OptionsActivityForm)actionForm;
        ActivityMapping actionMappings = LearningWebUtil.getActivityMapping(this.getServlet().getServletContext());
        ICoreLearnerService learnerService = this.getLearnerService();
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        if (!(activity instanceof OptionsActivity)) {
            log.error((Object)(className + ": activity not OptionsActivity " + activity.getActivityId()));
            return mapping.findForward("error");
        }
        OptionsActivity optionsActivity = (OptionsActivity)activity;
        form.setActivityID(activity.getActivityId());
        ArrayList<ActivityURL> activityURLs = new ArrayList<ActivityURL>();
        Set subActivities = optionsActivity.getActivities();
        Iterator i = subActivities.iterator();
        int completedCount = 0;
        while (i.hasNext()) {
            ActivityURL activityURL = LearningWebUtil.getActivityURL(actionMappings, learnerProgress, (Activity)i.next(), false, false);
            if (activityURL.isComplete()) {
                ++completedCount;
            }
            activityURLs.add(activityURL);
        }
        form.setActivityURLs(activityURLs);
        if (optionsActivity.getMinNumberOfOptionsNotNull() <= completedCount) {
            form.setFinished(true);
        }
        if (completedCount >= optionsActivity.getMaxNumberOfOptionsNotNull()) {
            form.setMaxActivitiesReached(true);
        }
        form.setMinimum(optionsActivity.getMinNumberOfOptionsNotNull());
        form.setMaximum(optionsActivity.getMaxNumberOfOptionsNotNull());
        form.setDescription(optionsActivity.getDescription());
        form.setTitle(optionsActivity.getTitle());
        form.setLessonID(learnerProgress.getLesson().getLessonId());
        form.setProgressID(learnerProgress.getLearnerProgressId());
        this.saveToken(request);
        LearningWebUtil.setupProgressInRequest(form, request, learnerProgress);
        String forward = "displayOptions";
        return mapping.findForward(forward);
    }
}

