/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.io.IOException;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GroupComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class GroupingAction
extends LamsDispatchAction {
    public static final String PARAM_FORCE_GROUPING = "force";
    private static Logger log = Logger.getLogger(GroupingAction.class);
    public static final String GROUPS = "groups";
    public static final String FINISHED_BUTTON = "finishedButton";
    public static final String LOCAL_FILES = "localFiles";
    public static final String TITLE = "title";
    public static final String MAX_LEARNERS_PER_GROUP = "maxLearnersPerGroup";
    public static final String VIEW_GROUP = "viewGroup";
    public static final String WAIT_GROUP = "waitGroup";
    public static final String SHOW_GROUP = "showGroup";
    public static final String CHOOSE_GROUP = "chooseGroup";

    public ActionForward performGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean forceGroup = WebUtil.readBooleanParam((HttpServletRequest)request, (String)PARAM_FORCE_GROUPING, (boolean)false);
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        if (!(activity instanceof GroupingActivity)) {
            log.error((Object)(LamsDispatchAction.className + ": activity not GroupingActivity"));
            return mapping.findForward("error");
        }
        Long lessonId = learnerProgress.getLesson().getLessonId();
        boolean groupingDone = learnerService.performGrouping(lessonId, activity.getActivityId(), LearningWebUtil.getUserId(), forceGroup);
        LearningWebUtil.putActivityInRequest(request, activity, learnerService);
        DynaActionForm groupForm = (DynaActionForm)form;
        groupForm.set("previewLesson", (Object)learnerProgress.getLesson().isPreviewLesson());
        groupForm.set(TITLE, (Object)activity.getTitle());
        LearningWebUtil.setupProgressInRequest(groupForm, request, learnerProgress);
        if (groupingDone) {
            request.setAttribute(FINISHED_BUTTON, (Object)Boolean.TRUE);
            return mapping.findForward(VIEW_GROUP);
        }
        if (((GroupingActivity)activity).getCreateGrouping().isLearnerChoiceGrouping()) {
            Integer maxNumberOfLeaernersPerGroup = learnerService.calculateMaxNumberOfLearnersPerGroup(lessonId, ((GroupingActivity)activity).getCreateGrouping().getGroupingId());
            this.prepareGroupData(request);
            request.setAttribute(MAX_LEARNERS_PER_GROUP, (Object)maxNumberOfLeaernersPerGroup);
            request.setAttribute(LOCAL_FILES, (Object)Boolean.FALSE);
            return mapping.findForward(CHOOSE_GROUP);
        }
        return mapping.findForward(WAIT_GROUP);
    }

    public ActionForward viewGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.prepareGroupData(request);
        request.setAttribute(LOCAL_FILES, (Object)Boolean.FALSE);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        request.setAttribute(FINISHED_BUTTON, (Object)new Boolean(mode == null || !mode.isTeacher()));
        return mapping.findForward(SHOW_GROUP);
    }

    public ActionForward exportPortfolio(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.prepareGroupData(request);
        request.setAttribute(FINISHED_BUTTON, (Object)Boolean.FALSE);
        request.setAttribute(LOCAL_FILES, (Object)Boolean.TRUE);
        return mapping.findForward(SHOW_GROUP);
    }

    public ActionForward completeActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        LearnerProgress progress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Activity groupingActivity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        Integer learnerId = LearningWebUtil.getUserId();
        return LearningWebUtil.completeActivity(request, response, LearningWebUtil.getActivityMapping(this.getServlet().getServletContext()), progress, groupingActivity, learnerId, learnerService, true);
    }

    private void prepareGroupData(HttpServletRequest request) {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        TreeSet groups = new TreeSet(new GroupComparator());
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        Grouping grouping = ((GroupingActivity)activity).getCreateGrouping();
        if (grouping != null) {
            groups.addAll(grouping.getGroups());
        }
        request.setAttribute(GROUPS, groups);
        request.setAttribute(TITLE, (Object)activity.getTitle());
        request.setAttribute("activityID", (Object)activity.getActivityId());
    }

    public ActionForward learnerChooseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        Long groupId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupId");
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Long lessonId = learnerProgress.getLesson().getLessonId();
        boolean learnerGroupped = learnerService.learnerChooseGroup(lessonId, activity.getActivityId(), groupId, LearningWebUtil.getUserId());
        if (learnerGroupped) {
            return this.viewGrouping(mapping, form, request, response);
        }
        Integer maxNumberOfLeaernersPerGroup = learnerService.calculateMaxNumberOfLearnersPerGroup(lessonId, ((GroupingActivity)activity).getCreateGrouping().getGroupingId());
        this.prepareGroupData(request);
        request.setAttribute(MAX_LEARNERS_PER_GROUP, (Object)maxNumberOfLeaernersPerGroup);
        request.setAttribute(LOCAL_FILES, (Object)Boolean.FALSE);
        return mapping.findForward(CHOOSE_GROUP);
    }
}

