/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.dto.ProgressActivityDTO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearnerAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(LearnerAction.class);
    private static IAuditService auditService;

    private ActionForward redirectToURL(ActionMapping mapping, HttpServletResponse response, String url) throws IOException, ServletException {
        if (url == null) {
            throw new ServletException("Tried to redirect to url but url is null");
        }
        String fullURL = WebUtil.convertToFullURL((String)url);
        response.sendRedirect(response.encodeRedirectURL(fullURL));
        return null;
    }

    protected FlashMessage handleException(Exception e, String methodKey, ICoreLearnerService learnerService) {
        log.error((Object)("Exception thrown " + methodKey), (Throwable)e);
        Object[] msg = new String[]{e.getMessage()};
        this.getAuditService().log(LearnerAction.class.getName() + ":" + methodKey, e.toString());
        return new FlashMessage(methodKey, (Object)learnerService.getMessageService().getMessage("error.system.learner", msg), 2);
    }

    public ActionForward joinLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Integer learner = null;
        try {
            learner = LearningWebUtil.getUserId();
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("The learner [" + learner + "] is joining the lesson [" + lessonID + "]"));
            }
            LearnerProgress learnerProgress = learnerService.joinLesson(learner, lessonID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The learner [" + learner + "] joined lesson. The" + "progress data is:" + learnerProgress.toString()));
            }
            LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
            ActivityMapping activityMapping = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
            String url = "learning/" + activityMapping.getDisplayActivityAction(lessonID);
            this.redirectToURL(mapping, response, url);
        }
        catch (Exception e) {
            log.error((Object)("An error occurred while learner " + learner + " attempting to join the lesson."), (Throwable)e);
            return mapping.findForward("error");
        }
        return null;
    }

    public ActionForward resumeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        FlashMessage message = null;
        try {
            Integer learner = LearningWebUtil.getUserId();
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("The learner [" + learner + "] is joining the lesson [" + lessonID + "]"));
            }
            LearnerProgress learnerProgress = learnerService.joinLesson(learner, lessonID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The learner [" + learner + "] joined lesson. The" + "porgress data is:" + learnerProgress.toString()));
            }
            LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
            ActivityMapping activityMapping = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
            message = new FlashMessage("joinLesson", (Object)activityMapping.getDisplayActivityAction(null));
        }
        catch (Exception e) {
            message = this.handleException(e, "joinLesson", learnerService);
        }
        String wddxPacket = WDDXProcessor.serialize((Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending Lesson joined acknowledge message to flash:" + wddxPacket));
        }
        response.getWriter().print(wddxPacket);
        return null;
    }

    public ActionForward exitLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        FlashMessage message = null;
        try {
            Integer learner = LearningWebUtil.getUserId();
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exiting lesson, lesson id is: " + lessonID));
            }
            learnerService.exitLesson(learner, lessonID);
            message = new FlashMessage("exitLesson", (Object)true);
        }
        catch (Exception e) {
            message = this.handleException(e, "exitLesson", learnerService);
        }
        String wddxPacket = WDDXProcessor.serialize((Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending Exit Lesson acknowledge message to flash:" + wddxPacket));
        }
        response.getWriter().print(wddxPacket);
        return null;
    }

    public ActionForward getLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        FlashMessage message = null;
        try {
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("get lesson..." + lessonID));
            }
            LessonDTO dto = learnerService.getLessonData(lessonID);
            message = new FlashMessage("getLesson", (Object)dto);
        }
        catch (Exception e) {
            message = this.handleException(e, "getLesson", learnerService);
        }
        String wddxPacket = WDDXProcessor.serialize((Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending getLesson data message to flash:" + wddxPacket));
        }
        response.getWriter().print(wddxPacket);
        return null;
    }

    public ActionForward getFlashProgressData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting Flash progress data...");
        }
        FlashMessage message = null;
        try {
            Integer learnerId = LearningWebUtil.getUserId();
            ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            LearnerProgressDTO learnerProgress = learnerService.getProgressDTOByLessonId(lessonId, learnerId);
            message = new FlashMessage("getFlashProgressData", (Object)learnerProgress);
        }
        catch (Exception e) {
            message = this.handleException(e, "getFlashProgressData", LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext()));
        }
        String wddxPacket = WDDXProcessor.serialize((Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending learner progress data to flash:" + wddxPacket));
        }
        response.getWriter().print(wddxPacket);
        return null;
    }

    public ActionForward getLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting url for learner activity...");
        }
        FlashMessage message = null;
        try {
            long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
            String url = this.getLearnerActivityURL(request, activityId);
            ProgressActivityDTO activityDTO = new ProgressActivityDTO(new Long(activityId), url);
            message = new FlashMessage("getLearnerActivityURL", (Object)activityDTO);
        }
        catch (Exception e) {
            message = this.handleException(e, "getLearnerActivityURL", LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext()));
        }
        String wddxPacket = WDDXProcessor.serialize((Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending learner activity url data to flash:" + wddxPacket));
        }
        response.getWriter().print(wddxPacket);
        return null;
    }

    private String getLearnerActivityURL(HttpServletRequest request, long activityId) {
        ActivityMapping activityMapping = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Integer learnerId = LearningWebUtil.getUserId();
        User learner = (User)LearnerServiceProxy.getUserManagementService(this.getServlet().getServletContext()).findById(User.class, (Serializable)learnerId);
        Activity requestedActivity = learnerService.getActivity(new Long(activityId));
        Lesson lesson = learnerService.getLessonByActivity(requestedActivity);
        String url = activityMapping.calculateActivityURLForProgressView(lesson, learner, requestedActivity);
        return url;
    }

    public ActionForward displayProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Integer learnerId = LearningWebUtil.getUserId();
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Object[] ret = learnerService.getStructuredActivityURLs(learnerId, lessonId);
        request.setAttribute("progressList", (Object)((List)ret[0]));
        request.setAttribute("currentActivityID", ret[1]);
        return mapping.findForward("displayProgress");
    }

    public ActionForward forceMove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        ActivityMapping activityMapping = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            Activity targetActivity = this.forceMoveShared(request, learnerService, lessonId);
            String url = !targetActivity.isFloating() ? activityMapping.getDisplayActivityAction(null) : activityMapping.getActivityURL(targetActivity);
            flashMessage = new FlashMessage("forceMove", (Object)activityMapping.getDisplayActivityAction(null));
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "forceMove", learnerService);
        }
        PrintWriter writer = response.getWriter();
        writer.println(flashMessage.serializeMessage());
        return null;
    }

    public ActionForward forceMoveRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        ActivityMapping activityMapping = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            Activity targetActivity = this.forceMoveShared(request, learnerService, lessonId);
            String url = !targetActivity.isFloating() ? "/learning" + activityMapping.getDisplayActivityAction(lessonId) : activityMapping.getActivityURL(targetActivity);
            return this.redirectToURL(mapping, response, url);
        }
        catch (Exception e) {
            log.error((Object)"Exception throw doing force move", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private Activity forceMoveShared(HttpServletRequest request, ICoreLearnerService learnerService, Long lessonId) {
        Integer learnerId = LearningWebUtil.getUserId();
        Long fromActivityId = null;
        Long toActivityId = null;
        String fromActId = request.getParameter("currentActivityID");
        String toActId = request.getParameter("destActivityID");
        if (fromActId != null) {
            try {
                fromActivityId = new Long(Long.parseLong(fromActId));
            }
            catch (Exception e) {
                fromActivityId = null;
            }
        }
        if (toActId != null) {
            try {
                toActivityId = new Long(Long.parseLong(toActId));
            }
            catch (Exception e) {
                toActivityId = null;
            }
        }
        Activity fromActivity = null;
        Activity toActivity = null;
        if (fromActivityId != null) {
            fromActivity = learnerService.getActivity(fromActivityId);
        }
        if (toActivityId != null) {
            toActivity = learnerService.getActivity(toActivityId);
        }
        learnerService.moveToActivity(learnerId, lessonId, fromActivity, toActivity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Force move for learner " + learnerId + " lesson " + lessonId + ". "));
        }
        return toActivity;
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }

    public ActionForward forwardToLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Forwarding to the url for learner activity..." + activityId));
        }
        String url = this.getLearnerActivityURL(request, activityId);
        return this.redirectToURL(mapping, response, url);
    }
}

