/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.notebook.service.IExtendedCoreNotebookService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotebookAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(NotebookAction.class);
    private static IAuditService auditService;
    private static final String VIEW_ALL = "viewAll";
    private static final String VIEW_SINGLE = "viewSingle";
    private static final String VIEW_JOURNALS = "viewJournals";
    private static final String ADD_NEW = "addNew";
    private static final String SAVE_SUCCESS = "saveSuccess";

    public ICoreNotebookService getNotebookService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IExtendedCoreNotebookService)webContext.getBean(CoreNotebookConstants.NOTEBOOK_SERVICE_BEAN_NAME);
    }

    public ActionForward viewAll(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IExtendedCoreNotebookService notebookService = (IExtendedCoreNotebookService)this.getNotebookService();
        DynaActionForm notebookForm = (DynaActionForm)actionForm;
        Integer learnerID = LearningWebUtil.getUserId();
        Long lessonID = (Long)notebookForm.get("lessonID");
        List entries = notebookService.getEntry(learnerID, CoreNotebookConstants.SCRATCH_PAD);
        request.getSession().setAttribute("entries", (Object)entries);
        request.setAttribute("lessonID", (Object)lessonID);
        return mapping.findForward(VIEW_ALL);
    }

    public ActionForward viewAllJournals(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<NotebookEntry> journals = null;
        DynaActionForm notebookForm = (DynaActionForm)actionForm;
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Integer userID = LearningWebUtil.getUserId();
        Long lessonID = (Long)notebookForm.get("lessonID");
        Lesson lesson = learnerService.getLesson(lessonID);
        User user = (User)LearnerServiceProxy.getUserManagementService(this.getServlet().getServletContext()).findById(User.class, (Serializable)userID);
        if (lesson.getUser() != null && lesson.getUser().getUserId().equals(userID)) {
            journals = this.getJournals(lesson.getLessonId());
        }
        if (lesson == null || lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(user)) {
            throw new UserAccessDeniedException("User " + userID + " may not retrieve journal entries for lesson " + lesson.getLessonId());
        }
        if (journals == null) {
            journals = this.getJournals(lesson.getLessonId());
        }
        request.getSession().setAttribute("journals", journals);
        request.setAttribute("lessonID", (Object)lessonID);
        return mapping.findForward(VIEW_JOURNALS);
    }

    private List<NotebookEntry> getJournals(Long lessonID) {
        ICoreNotebookService notebookService = this.getNotebookService();
        if (lessonID == null) {
            return null;
        }
        return notebookService.getEntry(lessonID, CoreNotebookConstants.SCRATCH_PAD, CoreNotebookConstants.JOURNAL_SIG);
    }

    public ActionForward viewEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IExtendedCoreNotebookService notebookService = (IExtendedCoreNotebookService)this.getNotebookService();
        DynaActionForm notebookForm = (DynaActionForm)actionForm;
        Long uid = (Long)notebookForm.get("uid");
        String mode = WebUtil.readStrParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        NotebookEntry entry = notebookService.getEntry(uid);
        if (mode != null) {
            request.setAttribute("mode", (Object)mode);
        }
        if (entry != null) {
            request.setAttribute("entry", (Object)entry);
        }
        return mapping.findForward(VIEW_SINGLE);
    }

    public ActionForward processNewEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreNotebookService notebookService = this.getNotebookService();
        DynaActionForm notebookForm = (DynaActionForm)actionForm;
        Long id = (Long)notebookForm.get("lessonID");
        String title = (String)notebookForm.get("title");
        String entry = (String)notebookForm.get("entry");
        String signature = (String)notebookForm.get("signature");
        Integer userID = LearningWebUtil.getUserId();
        notebookService.createNotebookEntry(id, CoreNotebookConstants.SCRATCH_PAD, signature, userID, title, entry);
        return this.viewAll(mapping, actionForm, request, response);
    }

    public ActionForward updateEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreNotebookService notebookService = this.getNotebookService();
        DynaActionForm notebookForm = (DynaActionForm)actionForm;
        Long uid = (Long)notebookForm.get("uid");
        Long id = (Long)notebookForm.get("lessonID");
        String title = (String)notebookForm.get("title");
        String entry = (String)notebookForm.get("entry");
        String signature = (String)notebookForm.get("signature");
        NotebookEntry entryObj = notebookService.getEntry(uid);
        Integer userID = LearningWebUtil.getUserId();
        if (userID != entryObj.getUser().getUserId()) {
            // empty if block
        }
        entryObj.setTitle(title);
        entryObj.setEntry(entry);
        entryObj.setExternalSignature(signature);
        notebookService.updateEntry(entryObj);
        return this.viewAll(mapping, actionForm, request, response);
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

