/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceException;
import org.lamsfoundation.lams.learning.web.action.ActivityAction;
import org.lamsfoundation.lams.learning.web.form.ActivityForm;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;

public class SequenceActivityAction
extends ActivityAction {
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws LearnerServiceException, UnsupportedEncodingException {
        ActivityForm form = (ActivityForm)actionForm;
        ActivityMapping actionMappings = LearningWebUtil.getActivityMapping(this.getServlet().getServletContext());
        Integer learnerId = LearningWebUtil.getUserId();
        ICoreLearnerService learnerService = this.getLearnerService();
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        if (!(activity instanceof SequenceActivity)) {
            log.error((Object)(className + ": activity not SequenceActivity " + activity.getActivityId()));
            return mapping.findForward("error");
        }
        ActionForward forward = null;
        SequenceActivity sequenceActivity = (SequenceActivity)activity;
        Activity firstActivityInSequence = sequenceActivity.getNextActivityByParent((Activity)new NullActivity());
        if (firstActivityInSequence != null && !firstActivityInSequence.isNull()) {
            learnerProgress = learnerService.chooseActivity(learnerId, learnerProgress.getLesson().getLessonId(), firstActivityInSequence, true);
            forward = actionMappings.getActivityForward(firstActivityInSequence, learnerProgress, true);
            LearningWebUtil.putActivityInRequest(request, firstActivityInSequence, learnerService);
            LearningWebUtil.setupProgressInRequest(form, request, learnerProgress);
            return forward;
        }
        return LearningWebUtil.completeActivity(request, response, actionMappings, learnerProgress, activity, learnerId, learnerService, true);
    }
}

