/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ForwardingActionForward;
import org.apache.struts.action.RedirectingActionForward;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceException;
import org.lamsfoundation.lams.learning.web.util.ActivityMappingStrategy;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;

public class ActivityMapping
implements Serializable {
    private static final long serialVersionUID = 5887602834473598770L;
    public static final String ERROR = "error";
    public static final String NO_SESSION_ERROR = "noSessionError";
    public static final String NO_ACCESS_ERROR = "noAccessError";
    public static final String DOUBLE_SUBMIT_ERROR = "doubleSubmitError";
    public static final String LEARNING = "learning";
    private ActivityMappingStrategy activityMappingStrategy = new ActivityMappingStrategy();
    private ILamsCoreToolService toolService;

    public ActionForward getActivityForward(Activity activity, LearnerProgress progress, boolean redirect) {
        ActionForward actionForward = null;
        String strutsAction = this.activityMappingStrategy.getActivityAction(activity);
        strutsAction = WebUtil.appendParameterToURL((String)strutsAction, (String)"progressID", (String)progress.getLearnerProgressId().toString());
        actionForward = activity != null && activity.isToolActivity() ? this.strutsActionToForward(strutsAction, activity, false) : this.strutsActionToForward(strutsAction, activity, redirect);
        return actionForward;
    }

    public ActionForward getProgressForward(LearnerProgress progress, boolean redirect, boolean displayParallelFrames, HttpServletRequest request, ICoreLearnerService learnerService) throws UnsupportedEncodingException {
        ActionForward actionForward = null;
        if (progress.isComplete()) {
            String strutsAction = this.getActivityMappingStrategy().getLessonCompleteAction();
            strutsAction = WebUtil.appendParameterToURL((String)strutsAction, (String)"progressID", (String)progress.getLearnerProgressId().toString());
            strutsAction = ActivityMapping.strutsActionToURL(strutsAction, null, true);
            actionForward = this.getClearFramesForward(strutsAction, progress.getLearnerProgressId().toString());
        } else if (!displayParallelFrames && progress.getParallelWaiting() == 1) {
            String strutsAction = this.getActivityMappingStrategy().getWaitingAction();
            actionForward = this.strutsActionToForward(strutsAction, null, redirect);
        } else if (progress.getParallelWaiting() == 2) {
            String activityURL = this.getActivityURL(progress.getNextActivity());
            actionForward = this.getClearFramesForward(activityURL, progress.getLearnerProgressId().toString());
        } else {
            actionForward = this.getActivityForward(progress.getNextActivity(), progress, redirect);
            if (progress.getNextActivity() != null) {
                Activity realActivity = learnerService.getActivity(progress.getNextActivity().getActivityId());
                request.setAttribute("activity", (Object)realActivity);
                LearningWebUtil.putActivityInRequest(request, progress.getNextActivity(), learnerService);
            }
        }
        return actionForward;
    }

    private ActionForward getClearFramesForward(String activityURL, String progressId) throws UnsupportedEncodingException {
        String encodedURL = URLEncoder.encode(activityURL, "UTF-8");
        ActionForward actionForward = null;
        String strutsAction = "/requestDisplay.do?url=" + encodedURL;
        strutsAction = WebUtil.appendParameterToURL((String)strutsAction, (String)"progressID", (String)progressId);
        actionForward = this.strutsActionToForward(strutsAction, null, false);
        return actionForward;
    }

    public String getActivityURL(Activity activity) {
        String strutsAction = this.activityMappingStrategy.getActivityAction(activity);
        return ActivityMapping.strutsActionToURL(strutsAction, activity, true);
    }

    public String getLearnerToolURL(Lesson lesson, Activity activity, User learner) {
        try {
            if (lesson.isPreviewLesson()) {
                return this.toolService.getToolLearnerPreviewURL(lesson.getLessonId(), activity, learner);
            }
            return this.toolService.getToolLearnerURL(lesson.getLessonId(), activity, learner);
        }
        catch (LamsToolServiceException e) {
            throw new LearnerServiceException(e.getMessage());
        }
    }

    public static String strutsActionToURL(String strutsAction, Activity activity, boolean useContext) {
        String url = strutsAction;
        if (activity != null) {
            url = WebUtil.appendParameterToURL((String)url, (String)"activityID", (String)activity.getActivityId().toString());
        }
        if (useContext) {
            String lamsUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL) + LEARNING;
            url = lamsUrl + url;
        }
        return url;
    }

    protected ActionForward strutsActionToForward(String strutsAction, Activity activity, boolean redirect) {
        ForwardingActionForward actionForward;
        if (redirect) {
            String activityURL = ActivityMapping.strutsActionToURL(strutsAction, activity, false);
            actionForward = new RedirectingActionForward(activityURL);
            actionForward.setName(WebUtil.getStrutsForwardNameFromPath((String)strutsAction));
        } else {
            actionForward = new ForwardingActionForward(strutsAction);
            actionForward.setName(WebUtil.getStrutsForwardNameFromPath((String)strutsAction));
        }
        return actionForward;
    }

    protected String strutsForwardToURL(ActionForward forward) {
        return Configuration.get((String)ConfigurationKeys.SERVER_URL) + LEARNING + forward.getPath();
    }

    public String calculateActivityURLForProgressView(Lesson lesson, User learner, Activity activity) {
        if (activity != null && activity.isToolActivity() || activity.isSystemToolActivity()) {
            return WebUtil.convertToFullURL((String)this.getLearnerToolURL(lesson, activity, learner));
        }
        return this.getActivityURL(activity);
    }

    public void setToolService(ILamsCoreToolService toolService) {
        this.toolService = toolService;
    }

    public ActivityMappingStrategy getActivityMappingStrategy() {
        return this.activityMappingStrategy;
    }

    public void setActivityMappingStrategy(ActivityMappingStrategy activityMappingStrategy) {
        this.activityMappingStrategy = activityMappingStrategy;
    }

    public ActionForward getCloseForward(Activity justCompletedActivity, Long lessonId) throws UnsupportedEncodingException {
        String closeWindowURLAction = this.activityMappingStrategy.getCloseWindowAction();
        String action = this.getDisplayActivityAction(lessonId);
        action = ActivityMapping.strutsActionToURL(action, null, true);
        action = WebUtil.appendParameterToURL((String)action, (String)"initialDisplay", (String)"false");
        action = URLEncoder.encode(action, "UTF-8");
        if (!justCompletedActivity.isFloating()) {
            closeWindowURLAction = WebUtil.appendParameterToURL((String)closeWindowURLAction, (String)"nextURL", (String)action);
        }
        if (justCompletedActivity.getParentActivity() != null && justCompletedActivity.getParentActivity().isParallelActivity()) {
            action = this.getActivityMappingStrategy().getWaitingAction();
            action = ActivityMapping.strutsActionToURL(action, null, true);
            action = URLEncoder.encode(action, "UTF-8");
            closeWindowURLAction = WebUtil.appendParameterToURL((String)closeWindowURLAction, (String)"waitURL", (String)action);
        }
        return this.strutsActionToForward(closeWindowURLAction, null, false);
    }

    public String getProgressBrokenURL() {
        return ActivityMapping.strutsActionToURL(this.activityMappingStrategy.getProgressBrokenAction(), null, true);
    }

    public String getCompleteActivityURL(Long activityId, Long progressId) {
        String url = ActivityMapping.strutsActionToURL(this.activityMappingStrategy.getCompleteActivityAction(), null, true);
        if (activityId != null) {
            url = WebUtil.appendParameterToURL((String)url, (String)"activityID", (String)activityId.toString());
        }
        if (progressId != null) {
            url = WebUtil.appendParameterToURL((String)url, (String)"progressID", (String)progressId.toString());
        }
        return url;
    }

    public String getDisplayActivityAction(Long lessonID) {
        if (lessonID != null) {
            return WebUtil.appendParameterToURL((String)"/DisplayActivity.do", (String)"lessonID", (String)lessonID.toString());
        }
        return "/DisplayActivity.do";
    }
}

