/*
 * Decompiled with CFR 0.152.
 */
package servletunit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import servletunit.ServletOutputStreamSimulator;

public class HttpServletResponseSimulator
implements HttpServletResponse {
    private OutputStream servOStream;
    private boolean calledGetWriter;
    private boolean calledGetOutputStream;
    private StringWriter stringWriter = null;
    private PrintWriter printWriter = null;
    private Locale locale = null;
    private int contentLength;
    private String contentType = null;
    private int status = 200;
    private String message = null;
    private HashMap headers = new HashMap();
    private HashMap cookies = new HashMap();
    String charEncoding;
    private boolean isCommitted = false;
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;

    public void addCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
    }

    public Cookie findCookie(String name) {
        return (Cookie)this.cookies.get(name);
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z").format(new Date(date)));
    }

    public void addHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            return (String)this.headers.get(name);
        }
        return null;
    }

    public void addIntHeader(String name, int value) {
        this.setIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public void flushBuffer() throws IOException {
        throw new UnsupportedOperationException("flushBuffer operation is not supported!");
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException("getBufferSize operation is not supported!");
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.US;
        }
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.calledGetWriter) {
            throw new IllegalStateException("The getWriter method has already been called");
        }
        ServletOutputStreamSimulator oStream = null;
        oStream = null == this.servOStream ? new ServletOutputStreamSimulator() : new ServletOutputStreamSimulator(this.servOStream);
        this.servOStream = null;
        this.calledGetOutputStream = true;
        return oStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.calledGetOutputStream) {
            throw new IllegalStateException("The getOutputStream method has already been called");
        }
        if (this.stringWriter == null) {
            this.stringWriter = new StringWriter();
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        this.calledGetWriter = true;
        return this.printWriter;
    }

    public StringBuffer getWriterBuffer() {
        if (this.stringWriter == null) {
            return null;
        }
        return this.stringWriter.getBuffer();
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setIsCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    public void reset() {
        this.calledGetOutputStream = false;
        this.calledGetWriter = false;
        this.contentLength = 0;
        this.contentType = null;
        this.stringWriter = null;
        this.printWriter = null;
        this.headers = new HashMap();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException("resetBuffer operation is not supported.");
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
        throw new AssertionFailedError("received error: " + sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc, msg);
        throw new AssertionFailedError("received error " + sc + " : " + msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.reset();
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException("setBufferSize operation not supported.");
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setDateHeader(String name, long date) {
        this.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("content-type")) {
            this.setContentType(value);
            return;
        }
        if (name.equalsIgnoreCase("content-length")) {
            this.setContentLength(Integer.parseInt(value));
            return;
        }
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        if (this.headers.containsKey(name)) {
            this.headers.remove(name);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public void setOutputStream(OutputStream out) {
        this.servOStream = out;
    }

    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String sm) {
        this.status = sc;
        this.message = sm;
    }

    public int getStatusCode() {
        return this.status;
    }

    public void setCharacterEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public String getMessage() {
        return this.message;
    }
}

