/*
 * Decompiled with CFR 0.152.
 */
package servletunit.struts;

import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import junit.framework.AssertionFailedError;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.util.RequestUtils;

public class Common {
    protected static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    protected static Log logger = LogFactory.getLog((Class)(class$servletunit$struts$Common == null ? (class$servletunit$struts$Common = Common.class$("servletunit.struts.Common")) : class$servletunit$struts$Common));
    static /* synthetic */ Class class$servletunit$struts$Common;
    static /* synthetic */ Class class$java$lang$String;

    protected static void verifyNoActionMessages(HttpServletRequest request, String key, String messageLabel) {
        Iterator iterator;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - request = " + request + ", key = " + key + ", messageLabel = " + messageLabel));
        }
        ActionMessages messages = (ActionMessages)request.getAttribute(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("retrieved ActionMessages = " + messages));
        }
        if (messages != null && (iterator = messages.get()).hasNext()) {
            StringBuffer messageText = new StringBuffer();
            while (iterator.hasNext()) {
                messageText.append(" \"");
                messageText.append(((ActionMessage)iterator.next()).getKey());
                messageText.append("\"");
            }
            throw new AssertionFailedError("was expecting no " + messageLabel + " messages, but received: " + messageText.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    protected static void verifyActionMessages(HttpServletRequest request, String[] messageNames, String key, String messageLabel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - request = " + request + ", messageNames = " + messageNames + ", key = " + key + ", messageLabel = " + messageLabel));
        }
        ActionMessages messages = (ActionMessages)request.getAttribute(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("retrieved ActionMessages = " + messages));
        }
        if (messages == null) {
            throw new AssertionFailedError("was expecting some " + messageLabel + " messages, but received none.");
        }
        if (messages.size() != messageNames.length) {
            throw new AssertionFailedError("was expecting " + messageNames.length + " " + messageLabel + " message(s), but received " + messages.size() + " " + messageLabel + " message(s)");
        }
        TransformIterator iter = new TransformIterator(messages.get(), new Transformer(){

            public Object transform(Object input) {
                return ((ActionMessage)input).getKey();
            }
        });
        Object[] messageKeys = (String[])IteratorUtils.toArray((Iterator)iter, (Class)(class$java$lang$String == null ? (class$java$lang$String = Common.class$("java.lang.String")) : class$java$lang$String));
        Arrays.sort(messageKeys);
        Arrays.sort(messageNames);
        for (int i = 0; i < messageNames.length; ++i) {
            if (messageNames[i].equals(messageKeys[i])) continue;
            StringBuffer mks = new StringBuffer();
            StringBuffer mns = new StringBuffer();
            for (int j = 0; j < messageKeys.length; ++j) {
                mks.append((String)messageKeys[j] + " ");
            }
            for (int k = 0; k < messageNames.length; ++k) {
                mns.append(messageNames[k] + " ");
            }
            throw new AssertionFailedError("received " + messageLabel + " messages: (" + mks + ") but expected (" + mns + ")");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"verifyActionMessages()");
        }
    }

    protected static ComponentDefinition getTilesForward(String forwardPath, HttpServletRequest request, ServletContext context, ServletConfig config) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - forwardPath = " + forwardPath + ", request = " + request + ", context = " + context + ", config = " + config));
        }
        String result = null;
        try {
            ComponentDefinition actionDefinition;
            ComponentDefinition definition = TilesUtil.getDefinition((String)forwardPath, (ServletRequest)request, (ServletContext)context);
            if (definition != null && logger.isDebugEnabled()) {
                logger.debug((Object)("found tiles definition - '" + forwardPath + "' = '" + result + "'"));
            }
            if ((actionDefinition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null && logger.isDebugEnabled()) {
                logger.debug((Object)("found tiles definition for action - '" + forwardPath + "' = '" + result + "'"));
            }
            if (actionDefinition != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("definition attributes: " + actionDefinition.getAttributes()));
                }
                return actionDefinition;
            }
            if (logger.isDebugEnabled() && definition != null) {
                logger.debug((Object)("definition attributes: " + definition.getAttributes()));
            }
            return definition;
        }
        catch (NoSuchDefinitionException nsde) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Exiting - caught NoSuchDefinitionException");
            }
            return null;
        }
        catch (DefinitionsFactoryException dfe) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Exiting - caught DefinitionsFactoryException");
            }
            return null;
        }
        catch (NullPointerException npe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting - caught NullPointerException");
            }
            return null;
        }
    }

    protected static void verifyTilesForward(String actionPath, String forwardName, String expectedDefinition, boolean isInputPath, HttpServletRequest request, ServletContext context, ServletConfig config) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - actionPath = " + actionPath + ", forwardName = " + forwardName + ", expectedDefinition = " + expectedDefinition));
        }
        String definitionName = null;
        if (forwardName == null && isInputPath) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"processing an input forward");
            }
            forwardName = Common.getActionConfig(actionPath, request, context).getInput();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved input forward name = " + forwardName));
            }
            if (forwardName == null) {
                throw new AssertionFailedError("Trying to validate against an input mapping, but none is defined for this Action.");
            }
            ComponentDefinition definition = Common.getTilesForward(forwardName, request, context, config);
            if (definition != null) {
                definitionName = definition.getName();
            }
        }
        if (!isInputPath) {
            ComponentDefinition definition;
            ForwardConfig expectedForward;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"processing normal forward");
            }
            if ((expectedForward = Common.findForward(actionPath, forwardName, request, context)) == null) {
                throw new AssertionFailedError("Cannot find forward '" + forwardName + "'  - it is possible that it is not mapped correctly.");
            }
            forwardName = expectedForward.getPath();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved forward name = " + forwardName));
            }
            if ((definition = Common.getTilesForward(forwardName, request, context, config)) != null) {
                definitionName = definition.getName();
            }
        }
        if (definitionName == null) {
            throw new AssertionFailedError("Could not find tiles definition mapped to forward '" + forwardName + "'");
        }
        if (!definitionName.equals(expectedDefinition)) {
            throw new AssertionFailedError("Was expecting tiles definition '" + expectedDefinition + "' but received '" + definitionName + "'");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    protected static void verifyForwardPath(String actionPath, String forwardName, String actualForwardPath, boolean isInputPath, HttpServletRequest request, ServletContext context, ServletConfig config) {
        String moduleName;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - actionPath = " + actionPath + ", forwardName = " + forwardName + ", actualForwardPath = " + actualForwardPath));
        }
        boolean usesTiles = false;
        boolean useModules = false;
        if (forwardName == null && isInputPath) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"processing an input forward");
            }
            forwardName = Common.getActionConfig(actionPath, request, context).getInput();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved input forward name = " + forwardName));
            }
            if (forwardName == null) {
                throw new AssertionFailedError("Trying to validate against an input mapping, but none is defined for this Action.");
            }
            String tilesForward = null;
            ComponentDefinition definition = Common.getTilesForward(forwardName, request, context, config);
            if (definition != null) {
                tilesForward = definition.getPath();
            }
            if (tilesForward != null) {
                forwardName = tilesForward;
                usesTiles = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved tiles definition for forward = " + forwardName));
                }
            }
        }
        if (!isInputPath) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"processing normal forward");
            }
            if (forwardName == null) {
                if (actualForwardPath == null) {
                    return;
                }
                throw new AssertionFailedError("Expected a null forward from action, but received '" + actualForwardPath + "'");
            }
            ForwardConfig expectedForward = Common.findForward(actionPath, forwardName, request, context);
            if (expectedForward == null) {
                throw new AssertionFailedError("Cannot find forward '" + forwardName + "'  - it is possible that it is not mapped correctly.");
            }
            forwardName = expectedForward.getPath();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved forward name = " + forwardName));
            }
            String tilesForward = null;
            ComponentDefinition definition = Common.getTilesForward(forwardName, request, context, config);
            if (definition != null) {
                tilesForward = definition.getPath();
            }
            if (tilesForward != null) {
                forwardName = tilesForward;
                usesTiles = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved tiles definition for forward = " + forwardName));
                }
            }
            useModules = !expectedForward.getContextRelative();
        }
        String string = moduleName = request.getServletPath() != null ? request.getServletPath() : "";
        if ((moduleName == null || moduleName.equalsIgnoreCase("")) && request.getAttribute(INCLUDE_SERVLET_PATH) != null) {
            moduleName = (String)request.getAttribute(INCLUDE_SERVLET_PATH);
        }
        moduleName = moduleName != null && moduleName.length() > 0 ? moduleName.substring(moduleName.indexOf(47), moduleName.lastIndexOf(47)) : "";
        if (!forwardName.startsWith("/")) {
            forwardName = "/" + forwardName;
        }
        forwardName = usesTiles ? request.getContextPath() + forwardName : (useModules || isInputPath ? request.getContextPath() + moduleName + forwardName : request.getContextPath() + forwardName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("added context path and module name to forward = " + forwardName));
        }
        if (actualForwardPath == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"actualForwardPath is null - this usually means it is not mapped properly.");
            }
            throw new AssertionFailedError("Was expecting '" + forwardName + "' but it appears the Action has tried to return an ActionForward that is not mapped correctly.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("expected forward = '" + forwardName + "' - actual forward = '" + actualForwardPath + "'"));
        }
        if (!forwardName.equals(Common.stripJSessionID(actualForwardPath))) {
            throw new AssertionFailedError("was expecting '" + forwardName + "' but received '" + actualForwardPath + "'");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    protected static String stripActionPath(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - path = " + path));
        }
        if (path == null) {
            return null;
        }
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Exiting - returning path = " + path));
        }
        return path;
    }

    protected static String stripJSessionID(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - path = " + path));
        }
        if (path == null) {
            return null;
        }
        String pathCopy = path.toLowerCase();
        int jsess_idx = pathCopy.indexOf(";jsessionid=");
        if (jsess_idx > 0) {
            StringBuffer buf = new StringBuffer(path);
            int queryIndex = pathCopy.indexOf("?");
            path = queryIndex > 0 ? buf.delete(jsess_idx, queryIndex).toString() : buf.delete(jsess_idx, buf.length()).toString();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Exiting - returning path = " + path));
        }
        return path;
    }

    protected static ActionForm getActionForm(String actionPath, HttpServletRequest request, ServletContext context) {
        ActionForm form;
        ActionConfig actionConfig;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - actionPath = " + actionPath + ", request = " + request + ", context = " + context));
        }
        if ("request".equals((actionConfig = Common.getActionConfig(actionPath, request, context)).getScope())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"looking for form in request scope");
            }
            form = (ActionForm)request.getAttribute(actionConfig.getAttribute());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"looking for form in session scope");
            }
            HttpSession session = request.getSession();
            form = (ActionForm)session.getAttribute(actionConfig.getAttribute());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
        return form;
    }

    protected static ForwardConfig findForward(String mappingName, String forwardName, HttpServletRequest request, ServletContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - mappingName = " + mappingName + ", forwardName = " + forwardName + ", request = " + request + ", context = " + context));
        }
        ForwardConfig forward = null;
        if (mappingName != null) {
            ActionConfig mapping = Common.getActionConfig(mappingName, request, context);
            ForwardConfig forwardConfig = forward = mapping == null ? null : mapping.findForwardConfig(forwardName);
        }
        if (forward == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"looking for forward globally");
            }
            ModuleConfig moduleConfig = Common.getModuleConfig(request, context);
            forward = moduleConfig.findForwardConfig(forwardName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("retrieved forward = " + forward));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
        return forward;
    }

    protected static ActionConfig getActionConfig(String mappingName, HttpServletRequest request, ServletContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - mappingName = " + mappingName + ", request = " + request + ", context = " + context));
        }
        ModuleConfig config = Common.getModuleConfig(request, context);
        ActionMapping actionMapping = (ActionMapping)config.findActionConfig(mappingName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("retrieved mapping = " + actionMapping));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
        return actionMapping;
    }

    protected static ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext context) {
        ModuleConfig config;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - request = " + request + ", context = " + context));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"looking for config in request context");
        }
        if ((config = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE")) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"looking for config in application context");
            }
            config = (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Exiting - returning " + config));
        }
        return config;
    }

    protected static void setActionForm(ActionForm form, HttpServletRequest request, String actionPath, ServletContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - form = " + form + ", request = " + request + ", actionPath = " + actionPath + ", context = " + context));
        }
        if (actionPath == null || actionPath.equalsIgnoreCase("")) {
            throw new IllegalStateException("You must call setRequestPathInfo() before calling setActionForm()!");
        }
        ActionConfig actionConfig = Common.getActionConfig(actionPath, request, context);
        if (actionConfig == null) {
            RequestUtils.selectModule((HttpServletRequest)request, (ServletContext)context);
            actionConfig = Common.getActionConfig(actionPath, request, context);
        }
        if (actionConfig.getScope().equals("request")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setting form in request context");
            }
            request.setAttribute(actionConfig.getAttribute(), (Object)form);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setting form in session context");
            }
            request.getSession().setAttribute(actionConfig.getAttribute(), (Object)form);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

