/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.EventNotificationService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;

public class DeliveryMethodMail
extends AbstractDeliveryMethod {
    private static DeliveryMethodMail instance;

    protected DeliveryMethodMail() {
        super((short)1, "MAIL", "Messages will be send by Mail");
    }

    public String send(Long userId, String subject, String message) throws InvalidParameterException {
        if (userId == null) {
            return "User ID should not be null.";
        }
        try {
            User user = (User)EventNotificationService.getInstance().getUserManagementService().findById(User.class, Integer.valueOf(userId.intValue()));
            if (user == null) {
                return "User with the provided ID was not found.";
            }
            String email = user.getEmail();
            if (StringUtils.isBlank((String)email)) {
                return "User's e-mail address is blank.";
            }
            this.sendFromSupportEmail(subject, email, message);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static DeliveryMethodMail getInstance() {
        if (instance == null) {
            instance = new DeliveryMethodMail();
        }
        return instance;
    }

    public void sendFromSupportEmail(String subject, String to, String body) throws AddressException, MessagingException {
        String supportEmail = Configuration.get("LamsSupportEmail");
        String smtpServer = Configuration.get("SMTPServer");
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);
        Session session = Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(session);
        if (!StringUtils.isBlank((String)supportEmail)) {
            message.setFrom((Address)new InternetAddress(supportEmail));
        }
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject == null ? "" : subject);
        message.setText(body == null ? "" : body);
        Transport.send((Message)message);
    }

    void notifyAdmin(String subject, String body) throws AddressException, MessagingException {
        String adminEmail = Configuration.get("LamsSupportEmail");
        if (!StringUtils.isEmpty((String)adminEmail)) {
            this.sendFromSupportEmail(subject, adminEmail, body);
        }
    }
}

