/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.BranchConditionDTO;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.web.TextSearchActionForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSearchCondition
extends BranchCondition
implements Cloneable {
    protected String allWords;
    protected String phrase;
    protected String anyWords;
    protected String excludedWords;
    public static final String WORD_DELIMITER_REGEX = "\\s";
    private static Logger log = Logger.getLogger(TextSearchCondition.class);
    protected boolean conditionsParsed = false;
    protected List<String> allWordsCondition = new ArrayList<String>();
    protected String phraseCondition;
    protected List<String> anyWordsCondition = new ArrayList<String>();
    protected List<String> excludedWordsCondition = new ArrayList<String>();

    public TextSearchCondition() {
    }

    public TextSearchCondition(BranchConditionDTO conditionDTO) {
        super(conditionDTO);
        this.allWords = conditionDTO.getAllWords();
        this.phrase = conditionDTO.getPhrase();
        this.anyWords = conditionDTO.getAnyWords();
        this.excludedWords = conditionDTO.getExcludedWords();
    }

    public TextSearchCondition(Long conditionId, Integer conditionUIID, Integer orderId, String name, String displayName, String type, String startValue, String endValue, String exactMatchValue, String allWords, String phrase, String anyWords, String excludedWords) {
        super(conditionId, conditionUIID, orderId, name, displayName, type, startValue, endValue, exactMatchValue);
        this.allWords = allWords;
        this.phrase = phrase;
        this.anyWords = anyWords;
        this.excludedWords = excludedWords;
    }

    @Override
    public BranchCondition clone(int uiidOffset) {
        Integer newConditionUIID = LearningDesign.addOffset(this.conditionUIID, uiidOffset);
        return new TextSearchCondition(null, newConditionUIID, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue, this.allWords, this.phrase, this.anyWords, this.excludedWords);
    }

    public Object clone() {
        return new TextSearchCondition(null, null, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue, this.allWords, this.phrase, this.anyWords, this.excludedWords);
    }

    public String getAllWords() {
        return this.allWords;
    }

    public List<String> getAllWordsCondition() {
        return this.allWordsCondition;
    }

    public String getAnyWords() {
        return this.anyWords;
    }

    public List<String> getAnyWordsCondition() {
        return this.anyWordsCondition;
    }

    public String getExcludedWords() {
        return this.excludedWords;
    }

    public List<String> getExcludedWordsCondition() {
        return this.excludedWordsCondition;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String getPhraseCondition() {
        return this.phraseCondition;
    }

    @Override
    public boolean isMet(ToolOutput output) {
        return output != null && this.matches(output.getValue().getString());
    }

    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        if (!this.conditionsParsed) {
            this.parseConditionStrings();
        }
        String lowerCaseText = text.toLowerCase();
        if (this.getExcludedWordsCondition() != null) {
            for (String excludedWord : this.getExcludedWordsCondition()) {
                if (!lowerCaseText.contains(excludedWord)) continue;
                return false;
            }
        }
        if (this.getAnyWordsCondition() != null) {
            boolean wordFound = false;
            for (String word : this.getAnyWordsCondition()) {
                if (!lowerCaseText.contains(word)) continue;
                wordFound = true;
                break;
            }
            if (!wordFound) {
                return false;
            }
        }
        if (this.getPhraseCondition() != null && !lowerCaseText.contains(this.getPhraseCondition())) {
            return false;
        }
        if (this.getAllWordsCondition() != null) {
            for (String word : this.getAllWordsCondition()) {
                if (lowerCaseText.contains(word)) continue;
                return false;
            }
        }
        return true;
    }

    public void parseConditionStrings() {
        this.parseConditionStrings(this.getAllWords(), this.getPhrase(), this.getAnyWords(), this.getExcludedWords());
    }

    public void parseConditionStrings(String allWordsString, String phraseString, String anyWordsString, String excludedWordsString) {
        int index;
        this.conditionsParsed = true;
        String trimmed = null;
        String[] splited = null;
        if (allWordsString != null) {
            trimmed = allWordsString.trim();
            splited = trimmed.split(WORD_DELIMITER_REGEX);
            for (index = 0; index < splited.length; ++index) {
                splited[index] = splited[index].toLowerCase();
            }
            this.setAllWordsCondition(Arrays.asList(splited));
        } else {
            this.setAllWordsCondition(null);
        }
        if (phraseString != null) {
            trimmed = phraseString.trim();
            this.setPhraseCondition(trimmed.toLowerCase());
        }
        if (anyWordsString != null) {
            trimmed = anyWordsString.trim();
            splited = trimmed.split(WORD_DELIMITER_REGEX);
            for (index = 0; index < splited.length; ++index) {
                splited[index] = splited[index].toLowerCase();
            }
            this.setAnyWordsCondition(Arrays.asList(splited));
        } else {
            this.setAnyWordsCondition(null);
        }
        if (excludedWordsString != null) {
            trimmed = excludedWordsString.trim();
            splited = trimmed.split(WORD_DELIMITER_REGEX);
            for (index = 0; index < splited.length; ++index) {
                splited[index] = splited[index].toLowerCase();
            }
            this.setExcludedWordsCondition(Arrays.asList(splited));
        } else {
            this.setExcludedWordsCondition(null);
        }
    }

    public void parseConditionStrings(TextSearchActionForm textSearchActionForm) {
        this.parseConditionStrings(textSearchActionForm.getAllWords(), textSearchActionForm.getPhrase(), textSearchActionForm.getAnyWords(), textSearchActionForm.getExcludedWords());
    }

    public void setAllWords(String allWords) {
        this.allWords = allWords;
        this.conditionsParsed = false;
    }

    public void setAnyWords(String anyWords) {
        this.anyWords = anyWords;
        this.conditionsParsed = false;
    }

    public void setExcludedWords(String excludedWords) {
        this.excludedWords = excludedWords;
        this.conditionsParsed = false;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
        this.conditionsParsed = false;
    }

    public void setPhraseCondition(String phraseCondition) {
        this.phraseCondition = phraseCondition;
    }

    @Override
    protected boolean isValid() {
        return true;
    }

    protected void setAllWordsCondition(List<String> allWordsCondition) {
        this.allWordsCondition = allWordsCondition;
    }

    protected void setAnyWordsCondition(List<String> anyWordsCondition) {
        this.anyWordsCondition = anyWordsCondition;
    }

    protected void setExcludedWordsCondition(List<String> excludedWordsCondition) {
        this.excludedWordsCondition = excludedWordsCondition;
    }
}

