/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;

public class DesignDetailDTO
extends BaseDTO {
    private Long learningDesignID;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Boolean editOverrideLock;
    private Date dateReadOnly;
    private Integer userID;
    private Integer editOverrideUserID;
    private String helpText;
    private Integer copyTypeID;
    private String version;
    private Integer designVersion;
    private Long parentLearningDesignID;
    private Integer workspaceFolderID;
    private String contentFolderID;

    public DesignDetailDTO() {
    }

    public DesignDetailDTO(Long learningDesignID, Integer learningDesignUIID, String description, String title, Long firstActivityID, Boolean validDesign, Boolean readOnly, Boolean editLock, Date dateReadOnly, Integer userID, Integer editOverrideUserID, String helpText, Integer copyTypeID, String version, Integer designVersion, Long parentLearningDesignID, Integer workspaceFolderID) {
        this.learningDesignID = learningDesignID;
        this.learningDesignUIID = learningDesignUIID;
        this.description = description;
        this.title = title;
        this.firstActivityID = firstActivityID;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.userID = userID;
        this.editOverrideUserID = editOverrideUserID;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.version = version;
        this.designVersion = designVersion;
        this.parentLearningDesignID = parentLearningDesignID;
        this.workspaceFolderID = workspaceFolderID;
    }

    public DesignDetailDTO(LearningDesign learningDesign) {
        this.learningDesignID = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : null;
        this.validDesign = learningDesign.getValidDesign();
        this.readOnly = learningDesign.getReadOnly();
        this.editOverrideLock = learningDesign.getEditOverrideLock();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.userID = learningDesign.getUser().getUserId();
        this.editOverrideUserID = learningDesign.getEditOverrideUser().getUserId();
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.version = learningDesign.getVersion();
        this.designVersion = learningDesign.getDesignVersion();
        this.parentLearningDesignID = learningDesign.getOriginalLearningDesign() != null ? learningDesign.getOriginalLearningDesign().getLearningDesignId() : null;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder().getWorkspaceFolderId();
        this.contentFolderID = learningDesign.getContentFolderID();
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getFirstActivityID() {
        return this.firstActivityID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public Long getParentLearningDesignID() {
        return this.parentLearningDesignID;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getEditOverrideLock() {
        return this.editOverrideLock;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getUserID() {
        return this.userID;
    }

    public Integer geteditOverrideUserID() {
        return this.editOverrideUserID;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getDesignVersion() {
        return this.designVersion;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }
}

