/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolAdapterContentManager;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LamsCoreToolService
implements ILamsCoreToolService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(LamsCoreToolService.class);
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private ISystemToolDAO systemToolDAO;
    private ToolContentIDGenerator contentIDGenerator;
    protected IToolContentDAO toolContentDAO;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public ISystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    @Override
    public ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        ToolSession toolSession = this.toolSessionDAO.getToolSessionByLearner(learner, activity);
        if (toolSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating tool session for [" + activity.getActivityId() + "," + activity.getTitle() + "] for learner [" + learner.getLogin() + "] lesson [" + lesson.getLessonId() + "," + lesson.getLessonName() + "]."));
            }
            toolSession = activity.createToolSessionForActivity(learner, lesson);
            this.toolSessionDAO.saveToolSession(toolSession);
            return toolSession;
        }
        return null;
    }

    @Override
    public Set createToolSessions(Set learners, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        Iterator iter = learners.iterator();
        HashSet<ToolSession> newToolSessions = new HashSet<ToolSession>();
        while (iter.hasNext()) {
            User learner = (User)iter.next();
            ToolSession toolSession = this.createToolSession(learner, activity, lesson);
            if (toolSession == null) continue;
            newToolSessions.add(toolSession);
        }
        return newToolSessions;
    }

    @Override
    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    @Override
    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    @Override
    public void notifyToolsToCreateSession(ToolSession toolSession, ToolActivity activity) throws ToolException {
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity.getTool());
            sessionManager.createToolSession(toolSession.getToolSessionId(), toolSession.getToolSessionName(), activity.getToolContentId());
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to create tool session. ToolActivity " + activity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public Long notifyToolToCopyContent(ToolActivity toolActivity, boolean setDefineLater, String customCSV) throws DataMissingException, ToolException {
        return this.notifyToToolAboutContent(toolActivity, setDefineLater, true, customCSV);
    }

    private Long notifyToToolAboutContent(ToolActivity toolActivity, boolean setDefineLater, boolean copyToolContent, String customCSV) {
        Long toolcontentID = toolActivity.getToolContentId();
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            if (copyToolContent) {
                toolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
                if (contentManager instanceof ToolAdapterContentManager) {
                    ToolAdapterContentManager adapterContentManager = (ToolAdapterContentManager)contentManager;
                    adapterContentManager.copyToolContent(toolActivity.getToolContentId(), toolcontentID, customCSV);
                } else {
                    contentManager.copyToolContent(toolActivity.getToolContentId(), toolcontentID);
                }
            }
            contentManager.setAsDefineLater(toolcontentID, setDefineLater && toolActivity.getDefineLater() != null && toolActivity.getDefineLater() != false);
            contentManager.setAsRunOffline(toolcontentID, toolActivity.getRunOffline() != null && toolActivity.getRunOffline() != false);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy/update the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return toolcontentID;
    }

    @Override
    public Long notifyToolOfStatusFlags(ToolActivity toolActivity) throws DataMissingException, ToolException {
        return this.notifyToToolAboutContent(toolActivity, true, false, null);
    }

    @Override
    public Long notifyToolToCopyContent(Long toolContentId, String customCSV) throws DataMissingException, ToolException {
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, toolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + toolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + toolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            if (contentManager instanceof ToolAdapterContentManager) {
                ToolAdapterContentManager toolAdapterContentManager = (ToolAdapterContentManager)contentManager;
                toolAdapterContentManager.copyToolContent(toolContentId, newToolcontentID, customCSV);
            } else {
                contentManager.copyToolContent(toolContentId, newToolcontentID);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy the tool content. ToolContentId " + toolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return newToolcontentID;
    }

    @Override
    public void notifyToolToDeleteContent(ToolActivity toolActivity) throws ToolException {
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            contentManager.removeToolContent(toolActivity.getToolContentId(), true);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to delete the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public SortedMap<String, ToolOutputDefinition> getOutputDefinitionsFromTool(Long toolContentId) throws ToolException {
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, toolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + toolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + toolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            return contentManager.getToolOutputDefinitions(toolContentId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to get the tool output definitions. ToolContentId " + toolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutputDefinitions(toolContentId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public ToolOutput getOutputFromTool(String conditionName, Long toolSessionId, Integer learnerId) throws ToolException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return this.getOutputFromTool(conditionName, session, learnerId);
    }

    @Override
    public ToolOutput getOutputFromTool(String conditionName, ToolSession toolSession, Integer learnerId) throws ToolException {
        if (toolSession == null) {
            String error = "The toolSession is not valid. Unable to get the tool output";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolSession.getToolActivity().getTool();
        if (tool == null) {
            String error = "The tool for toolSession " + toolSession.getToolSessionId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            Long longLearnerId = learnerId != null ? new Long(learnerId.longValue()) : null;
            return sessionManager.getToolOutput(conditionName, toolSession.getToolSessionId(), longLearnerId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to gt the tol output. toolSession " + toolSession.getToolSessionId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutput(name, toolSessionId, learnerId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> names, Long toolSessionId, Integer learnerId) throws ToolException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return this.getOutputFromTool(names, session, learnerId);
    }

    @Override
    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> names, ToolSession toolSession, Integer learnerId) throws ToolException {
        if (toolSession == null) {
            String error = "The toolSession is not valid. Unable to get the tool output";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolSession.getToolActivity().getTool();
        if (tool == null) {
            String error = "The tool for toolSession " + toolSession.getToolSessionId() + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(tool);
            Long longLearnerId = learnerId != null ? new Long(learnerId.longValue()) : null;
            return sessionManager.getToolOutput(names, toolSession.getToolSessionId(), longLearnerId);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to gt the tol output. toolSession " + toolSession.getToolSessionId();
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        catch (AbstractMethodError e) {
            String message = "Tool " + tool.getToolDisplayName() + " doesn't support the getToolOutput(name, toolSessionId, learnerId) method so no output definitions can be accessed.";
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    @Override
    public List getToolSessionsByLesson(Lesson lesson) {
        return this.toolSessionDAO.getToolSessionsByLesson(lesson);
    }

    @Override
    public void deleteToolSession(ToolSession toolSession) {
        if (toolSession == null) {
            log.error((Object)"deleteToolSession: unable to delete tool session as tool session is null.");
            return;
        }
        ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(toolSession.getToolActivity().getTool());
        try {
            sessionManager.removeToolSession(toolSession.getToolSessionId());
        }
        catch (DataMissingException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as toolSession does not exist"), (Throwable)e);
        }
        catch (ToolException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as tool threw an exception"), (Throwable)e);
        }
        this.toolSessionDAO.removeToolSession(toolSession);
    }

    @Override
    public String getToolLearnerURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerUrl();
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerPreviewURL(Long lessonID, Activity activity, User authorLearner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerPreviewUrl();
            return this.setupToolURLWithToolSession(toolActivity, authorLearner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerPreviewUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerProgressURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerProgressUrl();
            toolURL = this.appendUserIDToURL(learner, toolURL);
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonUserID(activity, lessonID, learner.getUserId(), sysTool.getLearnerProgressUrl());
        }
        return null;
    }

    @Override
    public String getToolMonitoringURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String url = toolActivity.getTool().getMonitorUrl();
            if (url != null) {
                return this.setupToolURLWithToolContent(toolActivity, url);
            }
        } else if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getMonitorUrl());
        }
        return null;
    }

    @Override
    public String getToolContributionURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String url = toolActivity.getTool().getContributeUrl();
            if (url != null) {
                return this.setupToolURLWithToolContent(toolActivity, url);
            }
        } else if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getContributeUrl());
        }
        return null;
    }

    @Override
    public String getToolDefineLaterURL(ToolActivity activity) throws LamsToolServiceException {
        ToolActivity toolActivity;
        String url;
        if (activity.isToolActivity() && (url = (toolActivity = activity).getTool().getDefineLaterUrl()) != null) {
            return this.setupToolURLWithToolContent(toolActivity, url);
        }
        return null;
    }

    @Override
    public String getToolModerateURL(ToolActivity activity) throws LamsToolServiceException {
        ToolActivity toolActivity;
        String url;
        if (activity.isToolActivity() && (url = (toolActivity = activity).getTool().getModerationUrl()) != null) {
            return this.setupToolURLWithToolContent(toolActivity, url);
        }
        return null;
    }

    private String appendUserIDToURL(User user, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "userID", user.getUserId().toString());
    }

    @Override
    public String setupToolURLWithToolSession(ToolActivity activity, User learner, String toolURL) throws LamsToolServiceException {
        ToolSession toolSession = this.getToolSessionByActivity(learner, activity);
        if (toolSession == null) {
            String error = "Unable to set up url as session does not exist. Activity " + (activity != null ? activity.getActivityId() + ":" + activity.getTitle() : "null") + " learner " + (learner != null ? learner.getUserId() + ":" + learner.getLogin() : "null");
            log.error((Object)error);
            throw new LamsToolServiceException(error);
        }
        return WebUtil.appendParameterToURL(toolURL, "toolSessionID", toolSession.getToolSessionId().toString());
    }

    public String setupURLWithActivityLessonUserID(Activity activity, Long lessonID, Integer userID, String learnerURL) {
        String url = this.setupURLWithActivityLessonID(activity, lessonID, learnerURL);
        if (url != null && userID != null) {
            url = WebUtil.appendParameterToURL(url, "userID", userID.toString());
        }
        return url;
    }

    public String setupURLWithActivityLessonID(Activity activity, Long lessonID, String learnerURL) {
        String url = learnerURL;
        if (url != null && activity != null) {
            url = WebUtil.appendParameterToURL(url, "activityID", activity.getActivityId().toString());
        }
        if (url != null && lessonID != null) {
            url = WebUtil.appendParameterToURL(url, "lessonID", lessonID.toString());
        }
        return url;
    }

    @Override
    public String setupToolURLWithToolContent(ToolActivity activity, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "toolContentID", activity.getToolContentId().toString());
    }

    private Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.context.getBean(tool.getServiceName());
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }
}

