/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.io.InputStream;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;

public interface IRepository {
    public static final String REPOSITORY_SERVICE_ID = "repositoryService";
    public static final String REPOSITORY_CONTEXT_PATH = "/org/lamsfoundation/lams/contentrepository/contentRepositoryApplicationContext.xml";
    public static final String LOCAL_CONTEXT_PATH = "/org/lamsfoundation/lams/contentrepository/contentRepositoryLocalApplicationContext.xml";

    public ITicket login(ICredentials var1, String var2) throws LoginException, AccessDeniedException, WorkspaceNotFoundException;

    public void addWorkspace(ICredentials var1, String var2) throws LoginException, AccessDeniedException, ItemExistsException, RepositoryCheckedException;

    public void createCredentials(ICredentials var1) throws AccessDeniedException, RepositoryCheckedException, ItemExistsException;

    public void updateCredentials(ICredentials var1, ICredentials var2) throws AccessDeniedException, RepositoryCheckedException;

    public NodeKey addFileItem(ITicket var1, InputStream var2, String var3, String var4, String var5) throws FileException, AccessDeniedException, InvalidParameterException;

    public NodeKey addPackageItem(ITicket var1, String var2, String var3, String var4) throws AccessDeniedException, InvalidParameterException, FileException;

    public NodeKey updateFileItem(ITicket var1, Long var2, String var3, InputStream var4, String var5, String var6) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException;

    public NodeKey updatePackageItem(ITicket var1, Long var2, String var3, String var4, String var5) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException;

    public IVersionedNode getFileItem(ITicket var1, Long var2, Long var3) throws AccessDeniedException, ItemNotFoundException, FileException;

    public IVersionedNode getFileItem(ITicket var1, Long var2, Long var3, String var4) throws AccessDeniedException, ItemNotFoundException, FileException;

    public List getPackageNodes(ITicket var1, Long var2, Long var3) throws AccessDeniedException, ItemNotFoundException, FileException;

    public SortedSet getVersionHistory(ITicket var1, Long var2) throws ItemNotFoundException, AccessDeniedException;

    public String[] deleteVersion(ITicket var1, Long var2, Long var3) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException;

    public String[] deleteNode(ITicket var1, Long var2) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException;

    public void logout(ITicket var1) throws AccessDeniedException;

    public SortedMap getNodeList(ITicket var1) throws AccessDeniedException;
}

