/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.contentrepository.IVersionDetail;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;

public class SimpleVersionDetail
implements IVersionDetail {
    private Long versionId;
    private Date createdDateTime;
    private String description;

    protected SimpleVersionDetail(Long versionId, Date createdDateTime, String description) {
        if (versionId == null) {
            throw new RepositoryRuntimeException("Version id missing, unable to create SimpleVersionDetail object.");
        }
        this.versionId = versionId;
        if (createdDateTime == null) {
            throw new RepositoryRuntimeException("Created date time is missing, unable to create SimpleVersionDetail object.");
        }
        this.createdDateTime = createdDateTime;
        this.description = description != null ? description : "";
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("versionId", (Object)this.getVersionId()).append("createdDateTime", (Object)this.getCreatedDateTime()).append("description", (Object)this.getDescription()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleVersionDetail)) {
            return false;
        }
        SimpleVersionDetail castOther = (SimpleVersionDetail)other;
        return new EqualsBuilder().append((Object)this.getVersionId(), (Object)castOther.getVersionId()).append((Object)this.getCreatedDateTime(), (Object)castOther.getCreatedDateTime()).append((Object)this.getDescription(), (Object)castOther.getDescription()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getVersionId()).append((Object)this.getCreatedDateTime()).append((Object)this.getDescription()).toHashCode();
    }

    public int compareTo(Object o) throws ClassCastException {
        IVersionDetail vdo = (IVersionDetail)o;
        if (vdo == null) {
            return -1;
        }
        int compValue = this.getVersionId().compareTo(vdo.getVersionId());
        if (compValue != 0) {
            return compValue;
        }
        compValue = this.getCreatedDateTime().compareTo(vdo.getCreatedDateTime());
        if (compValue != 0) {
            return compValue;
        }
        return this.getDescription().compareTo(vdo.getDescription());
    }
}

