/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.dao.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.dao.IFileDAO;

public class FileDAO
implements IFileDAO {
    private String repositoryLocation;
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$dao$file$FileDAO == null ? (class$org$lamsfoundation$lams$contentrepository$dao$file$FileDAO = FileDAO.class$("org.lamsfoundation.lams.contentrepository.dao.file.FileDAO")) : class$org$lamsfoundation$lams$contentrepository$dao$file$FileDAO));
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$dao$file$FileDAO;

    protected String[] generateFilePath(Long uuid, Long versionId) throws FileException {
        if (this.repositoryLocation == null) {
            throw new FileException("Repository location unknown. Cannot access files. This should have been configured in the Spring context.");
        }
        String directoryPath = this.repositoryLocation;
        if (uuid == null || uuid < 1L) {
            throw new FileException("Unable to generate new filename for uuid=" + uuid);
        }
        String uuidString = uuid.toString();
        if (uuidString.length() % 2 != 0) {
            uuidString = "0" + uuidString;
        }
        for (int i = 0; i < uuidString.length(); i += 2) {
            directoryPath = directoryPath + File.separator + uuidString.charAt(i) + uuidString.charAt(i + 1);
        }
        return new String[]{directoryPath, directoryPath + File.separator + versionId};
    }

    /*
     * Loose catch block
     */
    public String writeFile(Long uuid, Long versionId, InputStream is) throws FileException {
        String[] paths;
        block18: {
            String message3;
            paths = this.generateFilePath(uuid, versionId);
            boolean writeErrorOccured = false;
            File file = new File(paths[1]);
            if (file.exists()) {
                String msg = "File for uuid " + uuid + " versionId " + versionId + " already exists. Generated path was " + paths[1];
                this.log.error((Object)(msg + ". If this occurs again, it could be that there is a file on" + " disk but there is no record in the database. To check" + " if a record exists in the database, run the sql\n" + " \"select * from lams_cr_node node, lams_cr_node_version nv" + " where node.node_id = " + uuid + " and node.node_id = nv.node_id" + " and nv.version_id = " + versionId + "\". \nIf no rows are found, then move the problem file over to " + " a storage area (just in case it needs to be restored later)." + " If this problem re-occurs, then a bug report to LAMS should be submitted."));
                throw new FileException("File for uuid " + uuid + " versionId " + versionId + " already exists. Generated path was " + paths[1] + ". See log file for more help with this problem.");
            }
            File dir = new File(paths[0]);
            dir.mkdirs();
            OutputStream os = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing out file to " + file.getAbsolutePath()));
            }
            int bufLen = 1024;
            byte[] buf = new byte[1024];
            os = new FileOutputStream(file);
            BufferedInputStream in = new BufferedInputStream(is);
            int len = 0;
            while ((len = in.read(buf, 0, bufLen)) != -1) {
                os.write(buf, 0, len);
            }
            Object var14_16 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                message3 = "Unable to close supplied filestream due to IOException";
                this.log.error((Object)message3, (Throwable)e1);
                new FileException(message3, e1);
            }
            try {
                if (os != null) {
                    os.close();
                }
                break block18;
            }
            catch (IOException e2) {
                message3 = "Unable to close file in repository due to IOException";
                this.log.error((Object)message3, (Throwable)e2);
                new FileException(message3, e2);
            }
            break block18;
            {
                catch (IOException e) {
                    String message2 = "Unable to write file for uuid " + uuid + " versionId " + versionId + " due to an IOException. Generated path was " + paths[1];
                    this.log.error((Object)message2, (Throwable)e);
                    throw new FileException(message2, e);
                }
            }
            catch (Throwable throwable) {
                String message3;
                Object var14_17 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e1) {
                    message3 = "Unable to close supplied filestream due to IOException";
                    this.log.error((Object)message3, (Throwable)e1);
                    new FileException(message3, e1);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    message3 = "Unable to close file in repository due to IOException";
                    this.log.error((Object)message3, (Throwable)e2);
                    new FileException(message3, e2);
                }
                throw throwable;
            }
        }
        return paths != null ? paths[0] : null;
    }

    public InputStream getFile(Long uuid, Long versionId) throws FileException {
        String[] paths = this.generateFilePath(uuid, versionId);
        try {
            return new FileInputStream(paths[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FileException("Unable to read file for uuid " + uuid + " versionId " + versionId + " due to an IOException. Generated path was " + paths[1], e);
        }
    }

    public int delete(Long uuid, Long versionId) throws FileException {
        String[] paths = this.generateFilePath(uuid, versionId);
        int retValue = 0;
        File file = new File(paths[1]);
        if (file.exists()) {
            retValue = file.delete() ? 1 : -1;
        }
        switch (retValue) {
            case 0: {
                this.log.error((Object)("Unable to delete file " + file.getPath() + " as the file does not exist."));
                break;
            }
            case -1: {
                this.log.error((Object)("Unable to delete file " + file.getPath() + ". File does exist but can't be deleted for some (unknown) reason."));
            }
        }
        File dir = new File(paths[0]);
        String[] files = dir.list();
        if (files != null && files.length == 0) {
            dir.delete();
        }
        return retValue;
    }

    public String getFilePath(Long uuid, Long versionId) throws FileException {
        String[] paths = this.generateFilePath(uuid, versionId);
        return paths[1];
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

