/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.dao.IWorkspaceDAO;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class WorkspaceDAO
extends HibernateDaoSupport
implements IWorkspaceDAO {
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$dao$hibernate$WorkspaceDAO == null ? (class$org$lamsfoundation$lams$contentrepository$dao$hibernate$WorkspaceDAO = WorkspaceDAO.class$("org.lamsfoundation.lams.contentrepository.dao.hibernate.WorkspaceDAO")) : class$org$lamsfoundation$lams$contentrepository$dao$hibernate$WorkspaceDAO));
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$dao$hibernate$WorkspaceDAO;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$CrWorkspace;

    public CrWorkspace findByName(String workspaceName) {
        this.log.debug((Object)("Getting workspace for name " + workspaceName));
        String queryString = "from CrWorkspace as w where w.name = ?";
        List workspaces = this.getHibernateTemplate().find(queryString, (Object)workspaceName);
        if (workspaces.size() == 0) {
            this.log.debug((Object)"No workspaces found");
            return null;
        }
        CrWorkspace workspace = (CrWorkspace)workspaces.get(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returning workspace " + workspace.toString()));
        }
        return workspace;
    }

    public List findWorkspaceNodes(Long workspaceId) {
        CrWorkspace workspace = (CrWorkspace)this.find(class$org$lamsfoundation$lams$contentrepository$CrWorkspace == null ? (class$org$lamsfoundation$lams$contentrepository$CrWorkspace = WorkspaceDAO.class$("org.lamsfoundation.lams.contentrepository.CrWorkspace")) : class$org$lamsfoundation$lams$contentrepository$CrWorkspace, workspaceId);
        Set nodes = workspace.getCrNodes();
        int size = nodes.size();
        return new ArrayList(nodes);
    }

    public Object find(Class objClass, Serializable id) {
        try {
            return this.getHibernateTemplate().load(objClass, id);
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    public void insert(Object object) {
        this.getHibernateTemplate().save(object);
    }

    public void update(Object object) {
        this.getHibernateTemplate().update(object);
    }

    public void delete(Object object) {
        this.getHibernateTemplate().delete(object);
    }

    public List findAll(Class objClass) {
        String query = "from obj in class " + objClass.getName();
        return this.getHibernateTemplate().find(query);
    }

    public void flushSession() throws RepositoryCheckedException {
        try {
            this.getSession().flush();
        }
        catch (Exception e) {
            this.log.error((Object)"Exception occured during flush. ", (Throwable)e);
            throw new RepositoryCheckedException("Unable to write changes to db successfully (flush).", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

