/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.struts.action.RepositoryDispatchAction;
import org.lamsfoundation.lams.contentrepository.struts.form.AddFileContentForm;

public class AddFileContentAction
extends RepositoryDispatchAction {
    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FileException, AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        InputStream is;
        ITicket ticket = AddFileContentAction.getTicket(request);
        log.debug((Object)("In getNode, ticket is " + ticket));
        if (ticket == null) {
            log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        AddFileContentForm addFileContentForm = (AddFileContentForm)form;
        FormFile theFile = addFileContentForm.getTheFile();
        String filename = theFile.getFileName();
        String contentType = theFile.getContentType();
        String versionDescription = addFileContentForm.getDescription();
        Long uuid = addFileContentForm.getUuid();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding file content " + filename + " type " + contentType + " version description " + versionDescription + " for uuid " + uuid));
        }
        try {
            is = theFile.getInputStream();
        }
        catch (Exception e) {
            log.error((Object)"Error getting file from input form.", (Throwable)e);
            return this.returnError(mapping, request, "exception.file");
        }
        try {
            NodeKey nodeKey = null;
            nodeKey = uuid != null ? this.getRepository().updateFileItem(ticket, uuid, filename, is, contentType, versionDescription) : this.getRepository().addFileItem(ticket, is, filename, contentType, versionDescription);
        }
        catch (FileException e1) {
            log.error((Object)"FileException occured ", (Throwable)e1);
            throw e1;
        }
        catch (AccessDeniedException e1) {
            log.error((Object)"Not allowed to do this exception occured ", (Throwable)e1);
            throw e1;
        }
        catch (InvalidParameterException e1) {
            log.error((Object)"Parameter missing exception occured ", (Throwable)e1);
            throw e1;
        }
        catch (ItemNotFoundException e1) {
            log.error((Object)"Item Not Found exception occured ", (Throwable)e1);
            throw e1;
        }
        log.debug((Object)("File Uploaded, forwarding to " + mapping.findForward("success")));
        return mapping.findForward("success");
    }

    public ActionForward uploadPackage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FileException, AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        ITicket ticket = AddFileContentAction.getTicket(request);
        log.debug((Object)("In getNode, ticket is " + ticket));
        if (ticket == null) {
            log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        AddFileContentForm addFileContentForm = (AddFileContentForm)form;
        String dirName = addFileContentForm.getDirName();
        String entryString = addFileContentForm.getEntryString();
        String versionDescription = addFileContentForm.getDescription();
        Long uuid = addFileContentForm.getUuid();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding package content " + dirName + " start point " + entryString + " version description " + versionDescription + " for uuid " + uuid));
        }
        try {
            NodeKey nodeKey = null;
            nodeKey = uuid != null ? this.getRepository().updatePackageItem(ticket, uuid, dirName, entryString, versionDescription) : this.getRepository().addPackageItem(ticket, dirName, entryString, versionDescription);
        }
        catch (FileException e1) {
            log.error((Object)"FileException occured ", (Throwable)e1);
            throw e1;
        }
        catch (AccessDeniedException e1) {
            log.error((Object)"Not allowed to do this exception occured ", (Throwable)e1);
            throw e1;
        }
        catch (InvalidParameterException e1) {
            log.error((Object)"Parameter missing exception occured ", (Throwable)e1);
            throw e1;
        }
        catch (ItemNotFoundException e1) {
            log.error((Object)"Item Not Found exception occured ", (Throwable)e1);
            throw e1;
        }
        log.debug((Object)("File Uploaded, forwarding to " + mapping.findForward("success")));
        return mapping.findForward("success");
    }
}

