/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.struts.action.RepositoryDispatchAction;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Download
extends HttpServlet {
    private static IRepositoryService repository = null;
    protected static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$struts$action$Download == null ? (class$org$lamsfoundation$lams$contentrepository$struts$action$Download = Download.class$("org.lamsfoundation.lams.contentrepository.struts.action.Download")) : class$org$lamsfoundation$lams$contentrepository$struts$action$Download));
    private static final String expectedFormat = "Expected format /download?uuid<num>&version=<num> (version number optional) or /download/<uuid>/<version>/<relPath>";
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$struts$action$Download;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.handleCall(request, response);
        }
        catch (RepositoryCheckedException e) {
            this.errorInContent(request, response, "Repository threw an exception ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleCall(HttpServletRequest request, HttpServletResponse response) throws ServletException, BeansException, AccessDeniedException, ItemNotFoundException, FileException, ValueFormatException, IOException {
        long start = System.currentTimeMillis();
        ITicket ticket = RepositoryDispatchAction.getTicket(request);
        if (ticket == null) {
            this.errorInContent(request, response, "No ticket found in session. Unable to access .", null);
            return;
        }
        Long uuid = RepositoryDispatchAction.getLong(request.getParameter("uuid"));
        Long version = null;
        String callId = null;
        if (uuid != null) {
            callId = "download " + Math.random() + " " + uuid;
            version = RepositoryDispatchAction.getLong(request.getParameter("version"));
            IVersionedNode node = this.getFileItem(ticket, uuid, version, null);
            log.debug((Object)(callId + " getFileItem1 " + (System.currentTimeMillis() - start)));
            version = node.getVersion();
            if (node.isNodeType("PACKAGENODE")) {
                String initialPage;
                IValue value = node.getProperty("INITIALPATH");
                String string = initialPage = value != null ? value.getString() : null;
                if (initialPage == null || initialPage.length() == 0) {
                    this.errorInContent(request, response, "No initial page found for this set of content. Node Data is " + node.toString(), null);
                    return;
                }
                initialPage = request.getRequestURL() + "/" + uuid + "/" + version + "/" + initialPage;
                log.debug((Object)("Request url was " + request.getRequestURL()));
                log.debug((Object)("Servlet path was " + request.getServletPath()));
                log.debug((Object)("Attempting to redirect to initial page " + initialPage));
                response.sendRedirect(initialPage);
            } else {
                if (!node.isNodeType("FILENODE")) {
                    this.errorInContent(request, response, "Unsupported node type " + node.getNodeType() + ". Node Data is " + node.toString(), null);
                    return;
                }
                this.handleFileNode(request, response, node);
            }
        } else {
            String pathString = request.getPathInfo();
            String[] strings = this.deriveIdFile(pathString);
            uuid = RepositoryDispatchAction.getLong(strings[0]);
            version = RepositoryDispatchAction.getLong(strings[1]);
            String relPathString = strings[2];
            callId = "download " + Math.random() + " " + uuid;
            if (uuid == null) {
                this.errorInContent(request, response, "UUID value is missing. Expected format /download?uuid<num>&version=<num> (version number optional) or /download/<uuid>/<version>/<relPath>", null);
                return;
            }
            if (version == null) {
                this.errorInContent(request, response, "Version value is missing. Expected format /download?uuid<num>&version=<num> (version number optional) or /download/<uuid>/<version>/<relPath>", null);
                return;
            }
            if (relPathString == null) {
                this.errorInContent(request, response, "Filename is missing. Expected format /download?uuid<num>&version=<num> (version number optional) or /download/<uuid>/<version>/<relPath>", null);
                return;
            }
            log.debug((Object)(callId + " beforeGetFileItem2 " + (System.currentTimeMillis() - start)));
            IVersionedNode node = this.getFileItem(ticket, uuid, version, relPathString);
            log.debug((Object)(callId + " getFileItem2 " + (System.currentTimeMillis() - start)));
            if (!node.isNodeType("FILENODE")) {
                this.errorInContent(request, response, "Unexpected type of node " + node.getNodeType() + " Expected File node. Data is " + node, null);
                return;
            }
            this.handleFileNode(request, response, node);
        }
        log.debug((Object)(callId + " handleFileNode " + (System.currentTimeMillis() - start)));
    }

    private IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version, String relPathString) throws AccessDeniedException, ItemNotFoundException, FileException {
        try {
            IVersionedNode node = null;
            node = relPathString != null ? this.getRepository().getFileItem(ticket, uuid, version, relPathString) : this.getRepository().getFileItem(ticket, uuid, version);
            return node;
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception thrown calling repository.getFileItem(<ticket>," + uuid + "," + version + "," + relPathString + "). " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    protected void handleFileNode(HttpServletRequest request, HttpServletResponse response, IVersionedNode fileNode) throws IOException, FileException, ValueFormatException {
        String mimeType;
        IValue prop = fileNode.getProperty("MIMETYPE");
        String string = mimeType = prop != null ? prop.getString() : null;
        if (mimeType == null && (prop = fileNode.getProperty("FILENAME")) != null) {
            mimeType = this.getServletContext().getMimeType(prop.getString());
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        ServletOutputStream os = response.getOutputStream();
        InputStream is = fileNode.getFile();
        int c = is.read();
        while (c != -1) {
            os.write(c);
            c = is.read();
        }
        os.close();
        is.close();
    }

    private String[] deriveIdFile(String pathInfo) {
        String[] result = new String[3];
        if (pathInfo != null) {
            String[] strings = pathInfo.split("/", 4);
            int j = 0;
            for (int i = 0; i < strings.length && j < 3; ++i) {
                if (strings[i].length() <= 0) continue;
                result[j++] = strings[i];
            }
        }
        log.debug((Object)("Split path into following strings: '" + result[0] + "' '" + result[1] + "' '" + result[2]));
        return result;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.handleCall(request, response);
        }
        catch (RepositoryCheckedException e) {
            this.errorInContent(request, response, "Repository threw an exception ", e);
        }
    }

    public IRepositoryService getRepository() {
        if (repository == null) {
            System.err.println("Repository Demo calling context and getting repository singleton.");
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            repository = (IRepositoryService)wac.getBean("repositoryService");
        }
        return repository;
    }

    protected void errorInContent(HttpServletRequest request, HttpServletResponse response, String errMsg, Exception e) throws IOException {
        log.error((Object)errMsg, (Throwable)e);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<HTML>");
        out.println("  <HEAD><TITLE>Error Getting Document</TITLE></HEAD>");
        out.println("  <BODY>");
        out.println("<P>An error occurred: " + errMsg + "</p>");
        if (e != null) {
            out.println("<P>" + e.getMessage() + "</p>");
        }
        out.println("<P>Path details:</p>");
        out.println(this.dumpPath(request));
        out.println("  </BODY>");
        out.println("</HTML>");
        out.flush();
        out.close();
    }

    protected String dumpPath(HttpServletRequest request) {
        return "<TABLE><TR><TD>getContextPath</TD><TD>" + request.getContextPath() + "</TD><TR>" + "<TR><TD>getPathInfo</TD><TD>" + request.getPathInfo() + "</TD><TR>" + "<TR><TD>getPathTranslated</TD><TD>" + request.getPathTranslated() + "</TD><TR>" + "<TR><TD>getQueryString</TD><TD>" + request.getQueryString() + "</TD><TR>" + "<TR><TD>getRequestURI</TD><TD>" + request.getRequestURI() + "</TD><TR>" + "<TR><TD>getRequestURL</TD><TD>" + request.getRequestURL() + "</TD><TR>" + "<TR><TD>getServletPath</TD><TD>" + request.getServletPath() + "</TD><TR>" + "</TABLE> ";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

