/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.contentrepository.struts.action.Download;

public class TestLogin
extends Download {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.login(request);
            this.output(response);
        }
        catch (RepositoryCheckedException e) {
            this.outputError(response, e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.login(request);
            this.output(response);
        }
        catch (RepositoryCheckedException e) {
            this.outputError(response, e);
        }
    }

    protected void login(HttpServletRequest request) throws RepositoryCheckedException {
        String callId = "login handleCall " + Math.random();
        long start = System.currentTimeMillis();
        String workspaceName = request.getParameter("w");
        String toolName = request.getParameter("t");
        char[] toolId = request.getParameter("id").toCharArray();
        SimpleCredentials cred = new SimpleCredentials(toolName, toolId);
        ITicket ticket = this.getRepository().login(cred, workspaceName);
        request.getSession().setAttribute("ticket", (Object)ticket);
    }

    protected void output(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<HTML>");
        out.println("  <HEAD><TITLE>Logged In</TITLE></HEAD>");
        out.println("  <BODY>");
        out.println("<P>We have logged in.</p>");
        out.println("  </BODY>");
        out.println("</HTML>");
        out.flush();
        out.close();
    }

    protected void outputError(HttpServletResponse response, RepositoryCheckedException e) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<HTML>");
        out.println("  <HEAD><TITLE>Error Getting Document</TITLE></HEAD>");
        out.println("  <BODY>");
        out.println("<P>An error occurred: " + e.getMessage() + "</p>");
        out.println("  </BODY>");
        out.println("</HTML>");
        out.flush();
        out.close();
        System.err.println("Error thrown logging in.");
        e.printStackTrace(System.err);
    }
}

